package io.baltoro.service;


import java.util.List;
import java.util.Map;
import java.util.Set;

import io.baltoro.domain.BO;
import io.baltoro.domain.BOMD;
import io.baltoro.domain.ObjectTypeEnum;
import io.baltoro.domain.Permission;
import io.baltoro.exception.CreateNotAllowedException;
import io.baltoro.exception.NotFoundException;
import io.baltoro.exception.PermissionException;
import io.baltoro.exception.ReadNotAllowedException;
import io.baltoro.exception.ServiceException;

public interface Dao
{

	BO getBOByBaseUuid(String baseUuid) 
	throws ServiceException,NotFoundException,ReadNotAllowedException;
	
	List<BO> getBOs(List<String> uuids) throws ServiceException;
	
	List<BO> findBOByName(String name, ObjectTypeEnum type, String containerUuid) 
	throws ServiceException;
	
	List<BO> find(String name, ObjectTypeEnum type) 
	throws ServiceException;
			
	List<BO> findBOByMetadata(String metadataName, String value) 
	throws ServiceException;
	
	List<BO> findByStateType(String state, ObjectTypeEnum type, String containerUuid) 
	throws ServiceException;
	
	int countByStateType(String state, ObjectTypeEnum type, String containerUuid) 
	throws ServiceException;
	
	void save(BO bo) throws ServiceException,CreateNotAllowedException;
	
	void updateState(BO bo, String state) throws ServiceException,PermissionException;
	
				
	void saveMetadata(BO bo) throws ServiceException,PermissionException;
	
	void deleteMetadata(BO bo) throws ServiceException,PermissionException;
	
	void updateMetadata(BO bo, BOMD[] bomds) throws ServiceException,PermissionException;
	
	
	public boolean objectExists(String name, String containerUuid, ObjectTypeEnum type)
	throws ServiceException;
	
	public void savePermissions(Permission permission)	
	throws ServiceException;
	
	Map<String, Permission> getPermissions(Set<String> baseUuids)
	throws ServiceException;
	
	public Permission getPermission(String baseUuid)
	throws ServiceException;
	
	public void saveRelationship(String pBaseUuid, String cBaseUuid)	
	throws ServiceException;
	
	public void saveRelationship(String pBaseUuid, String cBaseUuid, int sortOrder)	
	throws ServiceException;
	
	public List<BO> findChildrenByType(String baseUuid, ObjectTypeEnum type)
	throws ServiceException;
	
	public List<String> getParentByType(String baseUuid, ObjectTypeEnum type)
	throws ServiceException;
}
