package io.baltoro.service;

import java.util.HashMap;
import java.util.Map;

import io.baltoro.domain.BO;

public class BOCache
{
	private static BOCache cache;
	
	private Map<String, BO> map = new HashMap<>(2000);
	
	private BOCache()
	{
		
	}
	
	static BOCache get()
	{
		if(cache == null)
		{
			cache = new BOCache();
		}
		return cache;
	}
	
	void add(String uuid, BO bo)
	{
		map.put(uuid, bo);
	}
	
	BO get(String uuid)
	{
		return map.get(uuid);
	}
	
	void remove(String uuid)
	{
		map.remove(uuid);
	}
	
}
