package io.baltoro.remote;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import io.baltoro.domain.App;
import io.baltoro.domain.BODefaults;
import io.baltoro.domain.BaltoroInstance;
import io.baltoro.exception.ServiceException;
import io.baltoro.service.InstanceService;
import io.baltoro.service.Service;
import io.baltoro.service.ServiceFactory;
import io.baltoro.util.UUIDGenerator;

public class InstanceServletHelper
{

	private HttpServletRequest req;
	private HttpServletResponse res;
	
	
	public InstanceServletHelper(HttpServletRequest req, HttpServletResponse res)
	{
		this.req = req;
		this.res = res;
	}
	
	int getAllowedThreadPerInstance()
	{
		String instanceUuid = req.getParameter("instanceUuid");
		String appUuid = req.getParameter("appUuid");
		
		
		App app = null;
		int allowedCount = -1;
		try
		{
			app = (App) ServiceFactory.getInstance().get(appUuid);
			int currentCount = WSSessions.get().getSessionCount(app.getName(), instanceUuid);
			int appCount = app.getAllowedInstanceThreadCount();//6
			int perInstCount = app.getAllowedPerInstanceThreadCount();//3
			
			allowedCount = perInstCount - currentCount;
		} 
		catch (ServiceException e)
		{
			e.printStackTrace();
		}
		
		return allowedCount;
	}
	
	String getInstanceUuid()
	{
		try
		{
			String appUuid = req.getParameter("appUuid");	
			String clusterPath = req.getParameter("clusterPath");	
			int liveThreads = 0;
			InstanceService instService = ServiceFactory.get(InstanceService.class);
			List<BaltoroInstance> insts = instService.find(appUuid);
			for (BaltoroInstance inst : insts)
			{
				if(!inst.getClusterPath().equals(clusterPath))
				{
					continue;
				}
				
				long t0 = System.currentTimeMillis();
				long t1 = inst.getLastHeartBeatOn().getTime();
				long dif = t0 - t1;
				
				if(dif > 45000)
				{
					return inst.getUuid();
				}
				else
				{
					liveThreads = liveThreads+inst.getThreadCount();
				}
			}
			
			Service service = ServiceFactory.getInstance();
			App app = service.get(appUuid, App.class);
			int tCount = app.getAllowedInstanceThreadCount();
			
		
			if(tCount > liveThreads)
			{
				BaltoroInstance instance = new BaltoroInstance();
				String uuid = UUIDGenerator.uuid("INST");
				instance.setAppUuid(appUuid);
				instance.setUuid(uuid);
				instance.setStartedOn(new Timestamp(System.currentTimeMillis()));
				instance.setThreadCount(app.getAllowedPerInstanceThreadCount());
				instance.setCreatedBy(BODefaults.BASE_USER);
				String localName =  Optional.ofNullable(InetAddress.getLocalHost().getHostName()).orElse(InetAddress.getLocalHost().getHostAddress());
				instance.setHostAddress(localName);
				instance.setRemoteAddress(req.getRemoteAddr());
				instance.setClusterPath(clusterPath);
				instService.insert(instance);
				
				return uuid;
			}
		
		} 
		catch (Exception e)
		{
			e.printStackTrace();
		}
			
		
		return "NOT ALLOWED";
	}
	
	
}
