package io.baltoro.remote;

import java.util.concurrent.ConcurrentLinkedQueue;

import io.baltoro.exception.NoRunningInstanceException;
import io.baltoro.to.WSTO;

public class InstancePoller extends Thread
{
	
	private String appName;
	boolean run = true;
	
	public InstancePoller(String appName)
	{
		this.appName = appName;
	}

	@Override
	public void run()
	{
		while(run)
		{
			if(!WSSessions.get().isRunning(appName))
			{
				System.out.println("1 No running instance for "+appName+", closing the polling thread ");
				break;
			}
			
			ConcurrentLinkedQueue<WSTO> queue = WSSessions.get().getQueue(appName);
			if(queue == null || queue.size() == 0)
			{
				sleep(appName+" queue is empty !");
				continue;
			}
			
			
			WSTO to = queue.peek();
			if(to == null)
			{
				sleep(appName+" no items in queue !");
				continue;
			}
			
			SessionInstance session;
			try
			{
				session = WSSessions.get().getSessionForWorker(appName, to.instanceUuid);
			} 
			catch (NoRunningInstanceException e)
			{
				System.out.println("2 No running instance for "+appName+", closing the polling thread ");
				break;
			}
			
			if(session == null)
			{
				sleep(appName+" no free instances ! try again in 5 secs ");
				continue;
			}
			
			to = queue.poll();
			
			RequestWorker worker = new RequestWorker(to, session);
			worker.start();
			
			
		}
	}
	
	private void sleep(String text)
	{
		try
		{
			long t0 = System.currentTimeMillis();
			String sync = appName+"-queue";
			synchronized (sync.intern())
			{
				System.out.println(text);
				sync.intern().wait(50000);
				System.out.println(text);
				System.out.println("Server waited : "+(System.currentTimeMillis() - t0));
			}
		} 
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	
}
