/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.Baltoro;
import io.baltoro.client.CheckRequestFilter;
import io.baltoro.client.CheckResponseFilter;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.jackson.JacksonFeature;

public class BOAPIClient {
    static Logger log = Logger.getLogger(BOAPIClient.class.getName());
    Client webClient;
    String blHost = "http://admin.baltoro.io";
    String host = "http://admin.baltoro.io";
    boolean online = false;

    BOAPIClient() {
        if (Baltoro.debug) {
            this.blHost = "http://admin.baltoro.io:8080";
            this.host = "http://admin.baltoro.io:8080";
        }
        CheckResponseFilter responseFilter = new CheckResponseFilter("admin", Baltoro.agentCookieMap);
        this.webClient = ((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).register(CheckRequestFilter.class)).register(responseFilter)).build();
        try {
            this.areYouThere();
            this.online = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.online = false;
        }
    }

    void areYouThere() throws Exception {
        log.info("... Are you There ...");
        WebTarget target = this.webClient.target(this.blHost).path("/areyouthere");
        Invocation.Builder ib = this.getIB(target);
        Response response = ib.get();
        String str = response.readEntity(String.class);
        log.info("response ==>" + str);
    }

    int getRemainingInsanceThreadsCount(String appName, String instanceUuid) throws Exception {
        log.info("... getInsanceThreadsCount ...");
        WebTarget target = this.webClient.target(this.blHost).path("/getRemainingInsanceThreadsCount");
        Form form = new Form();
        form.param("appName", appName);
        form.param("instanceUuid", instanceUuid);
        Invocation.Builder ib = this.getIB(target);
        Response response = ib.post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        String count = response.readEntity(String.class);
        return Integer.parseInt(count);
    }

    Invocation.Builder getIB(WebTarget target) {
        Invocation.Builder ib = target.request(MediaType.APPLICATION_JSON_TYPE);
        Set<String> cookieNames = Baltoro.agentCookieMap.keySet();
        StringBuffer buffer = new StringBuffer();
        for (String cookieName : cookieNames) {
            NewCookie cookie = Baltoro.agentCookieMap.get(cookieName);
            log.info("sending ============= >>>>>> [" + Baltoro.agentCookieMap.hashCode() + "]>>>>> " + cookieName + " : " + cookie);
            String _cookie = cookie.getName() + "=" + cookie.getValue() + ";";
            buffer.append(_cookie);
        }
        ib.header("Cookie", buffer.toString());
        return ib;
    }
}

