/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client.util;

import io.baltoro.client.util.StringUtil;
import io.baltoro.to.Keys;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CryptoUtil {
    private static String digits = "0123456789abcdef";
    private static Logger log = Logger.getLogger(CryptoUtil.class.getName());

    public static String genAESKey() throws RuntimeException {
        try {
            KeyGenerator generator = KeyGenerator.getInstance("AES", "BC");
            generator.init(2048);
            SecretKey key = generator.generateKey();
            String str = Base64.getEncoder().encodeToString(key.getEncoded());
            return str;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Keys generateKeys() throws RuntimeException {
        KeyPair pair = CryptoUtil.getKeyPair();
        byte[] privateBytes = pair.getPrivate().getEncoded();
        byte[] publicBytes = pair.getPublic().getEncoded();
        String privateKey = Base64.getEncoder().encodeToString(privateBytes);
        String publicKey = Base64.getEncoder().encodeToString(publicBytes);
        Keys keys = new Keys(privateKey, publicKey);
        keys.keypair = pair;
        return keys;
    }

    private static KeyPair getKeyPair() throws RuntimeException {
        KeyPairGenerator gen = null;
        try {
            gen = KeyPairGenerator.getInstance("RSA", "BC");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SecureRandom random = null;
        try {
            random = new SecureRandom();
        }
        catch (Exception e) {
            random = new SecureRandom();
        }
        gen.initialize(2048, random);
        KeyPair pair = gen.generateKeyPair();
        return pair;
    }

    public static String encrypt(String encodedKey, byte[] bytes) throws RuntimeException {
        try {
            byte[] keyBytes = Base64.getDecoder().decode(encodedKey);
            int size = keyBytes.length;
            Key key = null;
            if (size < 600) {
                key = KeyFactory.getInstance("RSA", "BC").generatePublic(new X509EncodedKeySpec(keyBytes));
            } else {
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
                KeyFactory rsaFact = KeyFactory.getInstance("RSA", "BC");
                RSAPrivateKey _pk = (RSAPrivateKey)rsaFact.generatePrivate(spec);
                key = _pk;
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            cipher.init(1, key);
            byte[] encBytes = cipher.doFinal(bytes);
            String encStr = Base64.getEncoder().encodeToString(encBytes);
            return encStr;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptWithPassword(String password, String input) throws RuntimeException {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), "fat".getBytes(), 65536, 256);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secret);
            byte[] ciphertext = cipher.doFinal(input.getBytes());
            String encStr = Base64.getEncoder().encodeToString(ciphertext);
            return encStr;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptWithPassword(String password, String input) throws RuntimeException {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), "fat".getBytes(), 65536, 256);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, secret);
            byte[] inbytes = Base64.getDecoder().decode(input.getBytes());
            byte[] ciphertext = cipher.doFinal(inbytes);
            return new String(ciphertext);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String encodedKey, String encodedInput) throws RuntimeException {
        try {
            byte[] keyBytes = StringUtil.decode(encodedKey);
            int size = keyBytes.length;
            Key key = null;
            if (size < 600) {
                key = KeyFactory.getInstance("RSA", "BC").generatePublic(new X509EncodedKeySpec(keyBytes));
            } else {
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
                KeyFactory rsaFact = KeyFactory.getInstance("RSA", "BC");
                RSAPrivateKey _pk = (RSAPrivateKey)rsaFact.generatePrivate(spec);
                key = _pk;
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            cipher.init(2, key);
            byte[] _input = Base64.getDecoder().decode(encodedInput);
            byte[] bytes = cipher.doFinal(_input);
            String encodedStr = StringUtil.encode(bytes);
            return encodedStr;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String hash(String str) throws RuntimeException {
        try {
            byte[] bytes = MessageDigest.getInstance("SHA-256").digest(str.getBytes());
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String hash(byte[] contentBytes) throws RuntimeException {
        try {
            byte[] bytes = MessageDigest.getInstance("SHA-256").digest(contentBytes);
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] checkPadding(byte[] input) {
        int i;
        if (input.length >= 16) {
            return input;
        }
        byte[] _input = new byte[16];
        for (i = 0; i < input.length; ++i) {
            _input[i] = input[i];
        }
        while (i < _input.length) {
            _input[i] = 20;
            ++i;
        }
        return _input;
    }

    public static String toHex(byte[] data, int length) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i != length; ++i) {
            int v = data[i] & 0xFF;
            buf.append(digits.charAt(v >> 4));
            buf.append(digits.charAt(v & 0xF));
        }
        return buf.toString();
    }

    public static String toHex(byte[] data) {
        return CryptoUtil.toHex(data, data.length);
    }

    public static String makeBlankString(int len) {
        char[] buf = new char[len];
        for (int i = 0; i != buf.length; ++i) {
            buf[i] = 32;
        }
        return new String(buf);
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

