/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.ClientWSSession;
import io.baltoro.client.ResponseWorker;
import io.baltoro.client.WSSessions;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ResponsePoller
extends Thread {
    boolean run = true;

    @Override
    public void run() {
        while (this.run) {
            int count = WSSessions.get().checkSessions();
            if (count == 0) {
                System.out.println("No running sessions plz restart the instance ");
                System.exit(1);
            } else {
                System.out.println("total valid connections [" + count + "] ");
            }
            ConcurrentLinkedQueue<ByteBuffer> queue = WSSessions.get().getResponseQueue();
            if (queue == null || queue.size() == 0) {
                this.sleep("response queue is empty !");
                continue;
            }
            ByteBuffer byteBuffer = queue.peek();
            if (byteBuffer == null) {
                this.sleep(" No items in response queue !");
                continue;
            }
            ClientWSSession session = WSSessions.get().getSession();
            if (session == null) {
                this.sleep(" no free session ! try again in 5 secs ");
                continue;
            }
            byteBuffer = queue.poll();
            ResponseWorker worker = new ResponseWorker(byteBuffer, session);
            worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(String text) {
        try {
            long t0 = System.currentTimeMillis();
            String sync = "response-queue";
            String string = sync.intern();
            synchronized (string) {
                System.out.println(text);
                sync.intern().wait(50000L);
                System.out.println("client lib response waited : " + (System.currentTimeMillis() - t0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

