/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.baltoro.client.Baltoro;
import io.baltoro.client.SendRedirect;
import io.baltoro.client.SessionManager;
import io.baltoro.client.UserSession;
import io.baltoro.client.WSSessions;
import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.client.util.ObjectUtil;
import io.baltoro.client.util.StringUtil;
import io.baltoro.exception.AuthException;
import io.baltoro.features.AbstractFilter;
import io.baltoro.features.Param;
import io.baltoro.to.APIError;
import io.baltoro.to.RequestContext;
import io.baltoro.to.ResponseContext;
import io.baltoro.to.UserSessionContext;
import io.baltoro.to.WSTO;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestWorker
extends Thread {
    private ByteBuffer byteBuffer;
    UserSession userSession;
    List<AbstractFilter> filters = new ArrayList<AbstractFilter>();
    static ObjectMapper mapper = new ObjectMapper();
    static ThreadLocal<RequestContext> requestCtx = new ThreadLocal();

    public RequestWorker(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResponseContext res;
        WSTO to = this.getWSTO();
        if (to == null) {
            System.out.println("ERROR PARSING WSTO !!!!!!! CHECK ");
            return;
        }
        RequestContext req = to.requestContext;
        requestCtx.set(req);
        to.responseContext = res = new ResponseContext();
        try {
            this.process(to);
        }
        catch (Exception e) {
            APIError er;
            SendRedirect sd;
            if (e instanceof SendRedirect) {
                sd = (SendRedirect)e;
                res.setRedirect(sd.getUrl());
            } else if (e.getCause() instanceof SendRedirect) {
                sd = (SendRedirect)e.getCause();
                res.setRedirect(sd.getUrl());
            } else if (e instanceof APIError) {
                er = (APIError)e;
                res.setError(er.getMessage());
            } else if (e.getCause() instanceof APIError) {
                er = (APIError)e.getCause();
                res.setRedirect(er.getMessage());
            } else if (e instanceof AuthException) {
                res.setError(e.getMessage());
            } else {
                res.setError(e.getMessage() + "---" + e.getCause().getMessage());
                e.printStackTrace();
            }
        }
        finally {
            to.requestContext = null;
            byte[] bytes = null;
            try {
                bytes = ObjectUtil.toJason(to);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("CANNOT CONVERT TO JSON , !!!! CHECK !");
                return;
            }
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            WSSessions.get().addToResponseQueue(buffer);
            requestCtx.set(null);
        }
        String sync = "response-queue";
        String string = sync.intern();
        synchronized (string) {
            sync.intern().notify();
        }
    }

    private WSTO getWSTO() {
        byte[] jsonBytes = this.byteBuffer.array();
        WSTO to = null;
        try {
            to = mapper.readValue(jsonBytes, WSTO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return to;
    }

    private void process(WSTO to) throws Exception {
        RequestContext req = to.requestContext;
        ResponseContext res = to.responseContext;
        if (StringUtil.isNotNullAndNotEmpty(req.getSessionId())) {
            this.userSession = SessionManager.getSession(req.getSessionId());
            UserSessionContext uctx = to.userSessionContext;
            if (uctx != null) {
                Object userName;
                this.userSession.userName = userName = uctx.getPrincipalName();
                Map attMap = null;
                try {
                    attMap = mapper.readValue(uctx.getAttJson(), Map.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (String key : attMap.keySet()) {
                    String val = (String)attMap.get(key);
                    this.userSession.attMap.put(key, val);
                }
            }
        }
        List<String> filterNames = WebMethodMap.getInstance().getFilterNames();
        for (String fNames : filterNames) {
            Class<AbstractFilter> _class = WebMethodMap.getInstance().getFilterClass(fNames);
            try {
                System.out.println(" filter  >>>>>>> " + fNames);
                AbstractFilter filter = _class.newInstance();
                this.filters.add(filter);
                filter.before(to, this.userSession);
            }
            catch (Exception e) {
                SendRedirect sd;
                if (e instanceof SendRedirect) {
                    sd = (SendRedirect)e;
                    res.setRedirect(sd.getUrl());
                    return;
                }
                if (e.getCause() instanceof SendRedirect) {
                    sd = (SendRedirect)e.getCause();
                    res.setRedirect(sd.getUrl());
                    return;
                }
                if (e instanceof AuthException) {
                    res.setError(e.getMessage());
                    return;
                }
                e.printStackTrace();
            }
        }
        WebMethod wm = WebMethodMap.getInstance().getMethod(req.getApiPath());
        if (wm == null) {
            String path = req.getApiPath();
            String[] tokens = path.split("/");
            for (int i = 0; i < tokens.length; ++i) {
                int lIndex = path.lastIndexOf(47);
                path = path.substring(0, lIndex);
                String lPath = req.getApiPath().substring(lIndex + 1);
                wm = WebMethodMap.getInstance().getMethod(path + "/*");
                if (wm == null) continue;
                req.setRelativePath(lPath);
                break;
            }
        }
        if (wm == null) {
            res.setError("API for path [" + req.getApiPath() + "] not found ");
        }
        this.checkAuth(wm, to, wm.getWebPath());
        Object returnObj = this.executeMethod(wm, to);
        for (AbstractFilter filter : this.filters) {
            filter.after(returnObj, to, this.userSession);
        }
        if (returnObj != null) {
            if (returnObj instanceof String) {
                to.responseContext.setData(((String)returnObj).getBytes());
            } else if (returnObj instanceof byte[]) {
                to.responseContext.setData((byte[])returnObj);
            } else {
                to.responseContext.setData(mapper.writeValueAsBytes(returnObj));
            }
        }
    }

    private void checkAuth(WebMethod wm, WSTO to, String path) throws AuthException {
        if (!wm.authRequired) {
            return;
        }
        String sessionId = to.requestContext.getSessionId();
        if (sessionId == null) {
            throw new AuthException("sessionId is null, cannot execute " + path);
        }
        UserSession userSession = Baltoro.getUserSession();
        if (userSession == null) {
            throw new AuthException("session object is null, cannot execute " + path);
        }
        String userName = userSession.getUserName();
        if (userName == null) {
            throw new AuthException("no user in session, cannot execute " + path);
        }
    }

    private Object executeMethod(WebMethod wMethod, WSTO to) throws Exception {
        RequestContext ctx = to.requestContext;
        Map<String, String[]> requestParam = ctx.getRequestParams();
        if (requestParam == null || requestParam.size() == 0) {
            requestParam = new HashMap<String, String[]>();
        }
        Class<?> _class = wMethod.get_class();
        Method method = wMethod.getMethod();
        boolean noParam = true;
        Parameter[] methodParms = method.getParameters();
        Object[] methodInputData = new Object[methodParms.length];
        for (int i = 0; i < methodParms.length; ++i) {
            noParam = true;
            Parameter param = methodParms[i];
            Class<?> paramClass = param.getType();
            String annoName = null;
            Annotation[] annos = param.getAnnotations();
            for (int j = 0; j < annos.length; ++j) {
                Annotation anno = annos[j];
                if (anno.annotationType() != Param.class) continue;
                Param annoPraram = (Param)anno;
                annoName = annoPraram.value();
                break;
            }
            String[] requestValue = requestParam.get(annoName);
            if (paramClass == String.class) {
                methodInputData[i] = requestValue[0];
                continue;
            }
            if (paramClass == String[].class) {
                methodInputData[i] = requestValue;
                continue;
            }
            if (paramClass == RequestContext.class) {
                methodInputData[i] = ctx;
                continue;
            }
            if (paramClass != UserSession.class) continue;
            methodInputData[i] = this.userSession;
        }
        Object obj = _class.newInstance();
        Object returnObj = method.invoke(obj, methodInputData);
        return returnObj;
    }
}

