/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.Baltoro;
import io.baltoro.client.WSSessions;
import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.client.util.ObjectUtil;
import io.baltoro.to.MgntContext;
import io.baltoro.to.PathTO;
import io.baltoro.to.WSTO;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;

public class BaltoroWSHeartbeat
extends Thread {
    int count = 0;
    OperatingSystemMXBean os = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    MemoryMXBean mem = ManagementFactory.getPlatformMXBean(MemoryMXBean.class);

    @Override
    public void run() {
        while (true) {
            ++this.count;
            try {
                WSTO to = new WSTO();
                to = new WSTO();
                to.instanceUuid = Baltoro.instanceUuid;
                to.appUuid = Baltoro.appUuid;
                to.appName = Baltoro.appName;
                String localName = null;
                MgntContext ctx = new MgntContext();
                if (this.count == 1) {
                    Map<String, WebMethod> map = WebMethodMap.getInstance().getMap();
                    ArrayList<PathTO> pathList = new ArrayList<PathTO>(200);
                    for (String key : map.keySet()) {
                        WebMethod wm = map.get(key);
                        PathTO pto = new PathTO();
                        pto.appUuid = to.appUuid;
                        pto.createdBy = to.instanceUuid;
                        pto.path = key;
                        pto.authRequired = wm.authRequired;
                        pathList.add(pto);
                        System.out.println("PATH ADDING TO LIST -> " + key + " --> " + map.get(key));
                    }
                    ctx.setPathTOs(pathList);
                    localName = new String(InetAddress.getLocalHost().getAddress());
                }
                ctx.setClusterPath(Baltoro.clusterPath);
                ctx.setHostName(localName);
                ctx.setCpuPercent((int)this.os.getSystemLoadAverage());
                long maxMem = (int)this.mem.getHeapMemoryUsage().getCommitted();
                long usedMem = (int)this.mem.getHeapMemoryUsage().getUsed();
                int freeMem = (int)(maxMem - usedMem) / 1000000;
                ctx.setMemoryGB(freeMem);
                ctx.setLocalTimestamp(System.currentTimeMillis());
                ctx.setHeartBeatCount(this.count);
                to.mgntContext = ctx;
                byte[] bytes = ObjectUtil.toJason(to);
                ByteBuffer msg = ByteBuffer.wrap(bytes);
                WSSessions.get().addToResponseQueue(msg);
                Thread.sleep(30000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

