/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.features.AbstractFilter;
import io.baltoro.features.Filter;
import io.baltoro.features.Path;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.security.RolesAllowed;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class AnnotationProcessor {
    static Logger log = Logger.getLogger(AnnotationProcessor.class.getName());
    Map<String, WebMethod> pathMap = new HashMap<String, WebMethod>(100);

    public Map<String, WebMethod> processAnnotation(String packageName) throws Exception {
        log.info("packageName = " + packageName);
        Set<Class<?>> classes = AnnotationProcessor.getClasses(packageName);
        for (Method[] methodArray : classes) {
            Annotation[] annoArray;
            log.info("class = " + methodArray);
            for (Annotation anno : annoArray = methodArray.getAnnotations()) {
                if (anno instanceof Filter) {
                    Filter filterAnno = (Filter)anno;
                    Method[] filter = methodArray;
                    WebMethodMap.getInstance().addFilter(filterAnno.value(), (Class<AbstractFilter>)filter);
                }
                if (anno instanceof Path) {
                    String cPath = ((Path)anno).value();
                    for (Method method : methodArray.getDeclaredMethods()) {
                        if (!method.isAnnotationPresent(Path.class)) continue;
                        Path pathAnno = method.getAnnotation(Path.class);
                        String fPath = null;
                        String mPath = pathAnno.value();
                        if (!mPath.startsWith("/")) {
                            mPath = "/" + mPath;
                        }
                        fPath = cPath.equals("/") ? mPath : cPath + mPath;
                        fPath = fPath.toLowerCase();
                        WebMethod wm = new WebMethod(fPath, (Class<?>)methodArray, method);
                        wm.authRequired = pathAnno.authRequired();
                        this.pathMap.put(fPath, wm);
                    }
                }
                if (!(anno instanceof RolesAllowed)) continue;
                RolesAllowed roleAnno = (RolesAllowed)anno;
                String[] roles = roleAnno.value();
                for (int i = 0; i < roles.length; ++i) {
                    System.out.println("role allowed" + roles[i]);
                }
            }
        }
        for (String string : this.pathMap.keySet()) {
            System.out.println("PATH -> " + string + " --> " + this.pathMap.get(string));
        }
        return this.pathMap;
    }

    static Set<Class<?>> getClasses(String packageName) throws Exception {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        HashSet masterClassSet = new HashSet();
        Set<Class<?>> set = reflections.getTypesAnnotatedWith(Path.class);
        masterClassSet.addAll(set);
        set = reflections.getTypesAnnotatedWith(Filter.class);
        masterClassSet.addAll(set);
        return masterClassSet;
    }
}

