/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.baltoro.client.Baltoro;
import io.baltoro.client.WSSessions;
import io.baltoro.to.UserSessionContext;
import io.baltoro.to.WSTO;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UserSession {
    private final String sessionId;
    Map<String, String> attMap = new HashMap<String, String>(200);
    Set<String> roles = new HashSet<String>();
    String userName;

    UserSession(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getAttribute(String name) {
        return this.attMap.get(name);
    }

    public void addAttribute(String name, String value) {
        this.attMap.put(name, value);
        this.sendSession();
    }

    public void addRoles(String roleName) {
        this.roles.add(roleName);
        this.sendSession();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this.sendSession();
    }

    void sendSession() {
        WSTO to = new WSTO();
        to.appUuid = Baltoro.appUuid;
        to.instanceUuid = Baltoro.instanceUuid;
        UserSessionContext uctx = new UserSessionContext();
        uctx.setSessionUuid(this.getSessionId());
        uctx.setPrincipalName(this.getUserName());
        ObjectMapper mapper = new ObjectMapper();
        String json = null;
        byte[] toBytes = null;
        try {
            json = mapper.writeValueAsString(this.attMap);
            System.out.println("------------");
            System.out.println(json);
            System.out.println("------------");
            uctx.setAttJson(json);
            to.userSessionContext = uctx;
            toBytes = mapper.writeValueAsBytes((Object)to);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(toBytes);
        WSSessions.get().addToResponseQueue(byteBuffer);
    }
}

