/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.AdminEP;
import io.baltoro.client.AnnotationProcessor;
import io.baltoro.client.BOAPIClient;
import io.baltoro.client.BaltoroWSHeartbeat;
import io.baltoro.client.ClientWSSession;
import io.baltoro.client.RequestPoller;
import io.baltoro.client.RequestWorker;
import io.baltoro.client.ResponsePoller;
import io.baltoro.client.SessionManager;
import io.baltoro.client.UserSession;
import io.baltoro.client.WSClient;
import io.baltoro.client.WSSessions;
import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.client.util.UUIDGenerator;
import io.baltoro.ep.ClassBuilder;
import io.baltoro.to.APIError;
import io.baltoro.to.AppTO;
import io.baltoro.to.PrivateDataTO;
import io.baltoro.to.RequestContext;
import io.baltoro.to.UserTO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.websocket.Session;
import javax.ws.rs.core.NewCookie;

public class Baltoro {
    static Logger log = Logger.getLogger(Baltoro.class.getName());
    static Map<String, Class<?>> pathClassMap;
    static Map<String, NewCookie> agentCookieMap;
    static String packages;
    private static BOAPIClient cs;
    private static boolean logedin;
    private static String email;
    private static String password;
    private static UserTO user;
    static String instanceUuid;
    public static boolean debug;
    static Properties props;
    static String appUuid;
    static String appPrivateKey;
    static String appName;
    static String userUuid;
    static File propFile;
    private static BaltoroWSHeartbeat mgntThread;
    static RequestPoller requestPoller;
    static ResponsePoller responsePoller;
    static String clusterPath;
    private static AdminEP adminEP;

    private Baltoro() {
    }

    private static Session startClient() throws Exception {
        HashMap<String, WebMethod> pathMap = new HashMap<String, WebMethod>(200);
        AnnotationProcessor p = new AnnotationProcessor();
        for (String _package : packages.split(",")) {
            Map<String, WebMethod> pMap = p.processAnnotation(_package.trim());
            pathMap.putAll(pMap);
        }
        WebMethodMap.getInstance().setMap(pathMap);
        int count = cs.getRemainingInsanceThreadsCount(appName, instanceUuid);
        System.out.println(" ++++++++Allowed count +++++++++++++ " + count);
        if (count < 1) {
            System.out.println("Exceed allowed count , exiting");
            System.exit(1);
        }
        ExecutorService executor = Executors.newFixedThreadPool(count);
        for (int i = 0; i < count; ++i) {
            Future<Session> future = executor.submit(new WSClient());
            Session session = future.get();
            ClientWSSession csession = new ClientWSSession(session);
            WSSessions.get().addSession(csession);
        }
        mgntThread = new BaltoroWSHeartbeat();
        mgntThread.start();
        requestPoller = new RequestPoller();
        requestPoller.start();
        responsePoller = new ResponsePoller();
        responsePoller.start();
        return null;
    }

    public static String getMainClassName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        StackTraceElement ste = stElements[stElements.length - 1];
        return ste.getClassName();
    }

    public static <T> T EndPointFactory(Class<T> _class) {
        try {
            Class<?> implClass = pathClassMap.get(_class.getName());
            if (implClass == null) {
                ClassBuilder builder = new ClassBuilder(_class);
                implClass = builder.buildClass();
                pathClassMap.put(_class.getName(), implClass);
            }
            Object obj = implClass.newInstance();
            return _class.cast(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setUserToSession(String name) {
        RequestContext rc = RequestWorker.requestCtx.get();
        if (rc == null) {
            return;
        }
        UserSession userSession = SessionManager.getSession(rc.getSessionId());
        userSession.setUserName(name);
    }

    public static UserSession getUserSession() {
        RequestContext rc = RequestWorker.requestCtx.get();
        UserSession userSession = SessionManager.getSession(rc.getSessionId());
        return userSession;
    }

    public static void start(String _package, String clusterPath) {
        String _debug = System.getProperty("baltoro.debug");
        System.out.println("running mod : " + _debug);
        if (_debug != null && _debug.equals("true")) {
            debug = true;
        }
        packages = _package;
        Baltoro.clusterPath = clusterPath != null ? clusterPath : Baltoro.clusterPath;
        Session session = Baltoro._start();
        System.out.println(session);
    }

    private static Session _start() {
        try {
            boolean useLocal = Baltoro.init();
            if (!useLocal) {
                FileOutputStream output = new FileOutputStream(propFile);
                AppTO selectedApp = Baltoro.getMyApp();
                PrivateDataTO to = adminEP.getBO(selectedApp.privateDataUuid, PrivateDataTO.class);
                props.put("app.key", to.privateKey);
                props.store(output, "updated on " + new Date());
            }
            Session session = Baltoro.startClient();
            return session;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Baltoro.start("io", "/*");
    }

    private static boolean init() throws Exception {
        String option;
        cs = new BOAPIClient();
        props = new Properties();
        adminEP = Baltoro.EndPointFactory(AdminEP.class);
        String propName = Baltoro.getMainClassName();
        String fileName = "." + propName + ".props";
        System.out.println(fileName);
        propFile = new File(fileName);
        if (propFile.exists()) {
            props.load(new FileInputStream(propFile));
            appPrivateKey = props.getProperty("app.key");
            appUuid = props.getProperty("app.uuid");
            appName = props.getProperty("app.name");
            userUuid = props.getProperty("user.uuid");
            email = props.getProperty("user.email");
            instanceUuid = props.getProperty("app.instance.uuid");
            packages = props.getProperty("packages", packages);
            clusterPath = props.getProperty("cluster.path", clusterPath);
            option = Baltoro.systemIn("Start " + appName + " ? [y/n] : ");
            if (option.equals("n")) {
                propFile.delete();
            } else {
                return true;
            }
        }
        option = Baltoro.systemIn("Do you have an account ? [y/n] : ");
        for (int i = 0; i < 3; ++i) {
            email = Baltoro.systemIn("email : ");
            password = Baltoro.systemIn("password : ");
            try {
                if (option.toLowerCase().equals("n")) {
                    user = adminEP.createUser(email, password);
                }
                user = adminEP.adminLogin(email, password);
                logedin = true;
                props.put("user.email", email);
                props.put("user.uuid", Baltoro.user.uuid);
                instanceUuid = UUIDGenerator.uuid("INST");
                props.put("app.instance.uuid", instanceUuid);
                props.put("packages", packages);
                props.put("cluster.path", clusterPath);
                return false;
            }
            catch (RuntimeException e) {
                System.out.println("=====> " + e.getMessage());
                continue;
            }
        }
        System.out.println("Would not process sfter 3 tries. restart the program");
        System.exit(1);
        return false;
    }

    private static AppTO getMyApp() throws Exception {
        if (!logedin) {
            return null;
        }
        boolean newApp = true;
        AppTO selectApp = null;
        AppTO[] apps = adminEP.getMyApps();
        if (apps.length > 0) {
            newApp = false;
            System.out.println(" ========  apps ========= ");
            System.out.println("0 -- to create new app : ");
            System.out.println(" ======== exisiting apps ========= ");
            int i = 1;
            for (AppTO appTO : apps) {
                System.out.println(i++ + " -- to start app : " + appTO.name);
            }
            String option = Baltoro.systemIn("enter option : ");
            if (option.equals("0")) {
                newApp = true;
            } else {
                int opt = Integer.parseInt(option);
                selectApp = apps[opt - 1];
                System.out.println("selected app : " + selectApp.name);
            }
        }
        if (newApp) {
            AppTO to = null;
            for (int i = 0; i < 5; ++i) {
                try {
                    String name = Baltoro.systemIn("enter name of your new app : ");
                    to = adminEP.createApp(name);
                    break;
                }
                catch (APIError e) {
                    System.out.println("************************");
                    System.out.println(e.getMessage());
                    System.out.println("************************");
                    continue;
                }
            }
            if (to == null) {
                System.out.println("5 tries, restart the app agaon");
                System.exit(1);
            }
            selectApp = to;
        }
        System.out.println(" =-==== " + selectApp.privateDataUuid);
        props.put("app.uuid", selectApp.uuid);
        props.put("app.name", selectApp.name);
        return selectApp;
    }

    static String systemIn(String msg) {
        try {
            System.out.print(msg);
            BufferedReader bufferRead = new BufferedReader(new InputStreamReader(System.in));
            String input = bufferRead.readLine();
            return input;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tT:%4$s > %5$s%6$s%n");
        pathClassMap = new HashMap(100);
        agentCookieMap = new HashMap<String, NewCookie>(100);
        logedin = false;
        debug = false;
        props = null;
        clusterPath = "/*";
    }
}

