/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.ep;

import io.baltoro.ep.EPMethodArg;
import java.util.ArrayList;
import java.util.List;

public class EPMethod {
    public String returnType = "void";
    public String name;
    public List<EPMethodArg> args = new ArrayList<EPMethodArg>();
    public String appName;
    public String path;

    public EPMethod(String returnType, String name, String appId, String path) {
        if (returnType != null && returnType.length() > 0) {
            this.returnType = returnType;
        }
        this.name = name;
        this.appName = appId;
        this.path = path;
    }

    public void addArg(String argType, String argName) {
        this.args.add(new EPMethodArg(argType, argName));
    }

    public String getCode() {
        StringBuffer buffer = new StringBuffer();
        StringBuffer epData = new StringBuffer();
        buffer.append("\tpublic " + this.returnType + " " + this.name + "(");
        boolean found = false;
        for (EPMethodArg arg : this.args) {
            found = true;
            buffer.append(arg.type + " " + arg.name + ", ");
            epData.append("\t\tdata.add(\"" + arg.name + "\"," + arg.name + ");\r\n");
        }
        if (found) {
            buffer.delete(buffer.length() - 2, buffer.length());
        }
        buffer.append(")\n");
        buffer.append("\t{\n");
        buffer.append("\t\tString appName = \"" + this.appName + "\";\r\n");
        buffer.append("\t\tString path = \"" + this.path + "\";\r\n");
        buffer.append("\t\tEPData data = new EPData();\r\n");
        buffer.append(epData.toString());
        buffer.append("\t\tCloudServer server = new CloudServer(appName);\r\n");
        buffer.append("\t\t" + this.returnType + " obj = server.execute(path, data, " + this.returnType + ".class);\r\n");
        buffer.append("\t\treturn obj;\r\n");
        buffer.append("\t}\n");
        return buffer.toString();
    }
}

