/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.ep;

import io.baltoro.client.CheckRequestFilter;
import io.baltoro.client.CheckResponseFilter;
import io.baltoro.ep.EPData;
import io.baltoro.util.ObjectUtil;
import io.baltoro.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.jackson.JacksonFeature;

public class CloudServer {
    static ExecutorService executor = Executors.newWorkStealingPool();
    static Logger log = Logger.getLogger(CloudServer.class.getName());
    Client client;
    String host;
    Map<String, NewCookie> cookieMap = new HashMap<String, NewCookie>(100);
    boolean online = false;

    public CloudServer(String appName) {
        CheckResponseFilter responseFilter = new CheckResponseFilter(this.cookieMap);
        this.host = "http://" + appName + ".baltoro.io/baltoro/app";
        this.client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).register(CheckRequestFilter.class)).register(responseFilter)).build();
        try {
            this.online = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.online = false;
        }
    }

    void areYouThere() throws Exception {
        log.info("... Are you There ...");
        WebTarget target = this.client.target(this.host).path("/baltoro/api/areyouthere");
        Invocation.Builder ib = this.getIB(target);
        Response response = ib.get();
        this.handleCookie(response);
    }

    void handleCookie(Response response) {
        Map<String, NewCookie> map = response.getCookies();
        for (String key : map.keySet()) {
            NewCookie cookie = map.get(key);
            log.info("received ============= >>>>>>>>>>> " + key + " : " + cookie);
            this.cookieMap.put(key, cookie);
        }
    }

    Invocation.Builder getIB(WebTarget target) {
        Invocation.Builder ib = target.request(MediaType.APPLICATION_JSON_TYPE);
        Set<String> cookieNames = this.cookieMap.keySet();
        for (String cookieName : cookieNames) {
            Cookie cookie = this.cookieMap.get(cookieName);
            log.info("sending ============= >>>>>>>>>>> " + cookieName + " : " + cookie);
            ib.cookie(cookie);
        }
        return ib;
    }

    public <T> T execute(String path, EPData data, Class<T> returnType) {
        WebTarget target = this.client.target(this.host).path(path);
        Form form = new Form();
        List<Object[]> list = data.list;
        for (Object[] objects : list) {
            String name = (String)objects[0];
            String value = (String)objects[1];
            form.param(name, value);
        }
        Invocation.Builder ib = this.getIB(target);
        Response response = ib.post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        this.handleCookie(response);
        String error = response.getHeaderString("BALTORO-ERROR");
        if (StringUtil.isNotNullAndNotEmpty(error)) {
            return (T)error;
        }
        String str = response.readEntity(String.class);
        Object obj = ObjectUtil.toObject(returnType, str.getBytes());
        return obj;
    }

    public Response execute(Form form, WebTarget target) {
        Callable<Response> apiCall = () -> {
            Invocation.Builder ib = this.getIB(target);
            Response response = ib.post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            return response;
        };
        Future<Response> future = executor.submit(apiCall);
        return null;
    }
}

