/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.BaltoroByteBufferMessageHandler;
import io.baltoro.client.BaltoroTextMessageHandler;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.Session;

public class BaltoroClientEndpoint
extends Endpoint {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private String appId;

    public BaltoroClientEndpoint(String appId) {
        this.appId = appId;
    }

    @Override
    public void onOpen(Session session, EndpointConfig config) {
        this.log.info(" ******** Connected ... " + session.getId());
        session.addMessageHandler(new BaltoroTextMessageHandler(this.appId, session));
        session.addMessageHandler(new BaltoroByteBufferMessageHandler(this.appId, session));
    }

    @Override
    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        this.log.info(String.format("Session %s close because of %s", session, closeReason));
    }
}

