/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.AnnotationProcessor;
import io.baltoro.client.BOAPIClient;
import io.baltoro.client.BaltoroClientConfigurator;
import io.baltoro.client.BaltoroClientEndpoint;
import io.baltoro.client.BaltoroWSPing;
import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.ep.ClassBuilder;
import io.baltoro.to.AppTO;
import io.baltoro.to.UserTO;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;

public class Baltoro {
    static Logger log = Logger.getLogger(Baltoro.class.getName());
    private static Map<String, Class<?>> classMap;
    private String packages;
    private BOAPIClient cs;
    boolean logedin = false;
    private String email;
    private String password;
    String sessionId;
    UserTO user;
    AppTO currentApp;

    private Baltoro() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Session startClient() throws Exception {
        HashMap<String, WebMethod> pathMap = new HashMap<String, WebMethod>(200);
        AnnotationProcessor p = new AnnotationProcessor();
        for (String _package : this.packages.split(",")) {
            Map<String, WebMethod> pMap = p.processAnnotation(_package);
            pathMap.putAll(pMap);
        }
        WebMethodMap.getInstance().setMap(pathMap);
        ExecutorService executor = Executors.newWorkStealingPool();
        Future<Session> future = executor.submit(() -> {
            try {
                ClientManager clientManager = ClientManager.createClient();
                BaltoroClientConfigurator clientConfigurator = new BaltoroClientConfigurator(this.sessionId);
                ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator(clientConfigurator).build();
                BaltoroClientEndpoint instance = new BaltoroClientEndpoint(this.currentApp.uuid);
                Session session = clientManager.connectToServer(instance, config, new URI("ws://" + this.currentApp.uuid + ".baltoro.io/baltoro/ws"));
                return session;
            }
            catch (Exception e) {
                throw new IllegalStateException("task interrupted", e);
            }
        });
        Session session = future.get();
        BaltoroWSPing thread = new BaltoroWSPing(session);
        thread.start();
        return session;
    }

    public static <T> T EndPointFactory(Class<T> _class) {
        try {
            Class<?> implClass = classMap.get(_class.getName());
            if (implClass == null) {
                ClassBuilder builder = new ClassBuilder(_class);
                implClass = builder.buildClass();
                classMap.put(_class.getName(), implClass);
            }
            Object obj = implClass.newInstance();
            return (T)obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Session start(String _package) {
        try {
            Baltoro baltoro = new Baltoro();
            baltoro.currentApp = baltoro.getMyApp();
            baltoro.packages = _package;
            Session session = baltoro.startClient();
            return session;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Baltoro.start("io");
    }

    private void init() throws Exception {
        this.cs = new BOAPIClient(this);
        String option = this.systemIn("Do you have an account ? [y/n] : ");
        for (int i = 0; i < 3; ++i) {
            this.email = this.systemIn("email : ");
            this.password = this.systemIn("password : ");
            try {
                if (option.toLowerCase().equals("n")) {
                    this.user = this.cs.createUser(this.email, this.password);
                }
                this.user = this.cs.login(this.email, this.password);
                this.logedin = true;
                return;
            }
            catch (RuntimeException e) {
                System.out.println("=====> " + e.getMessage());
                continue;
            }
        }
        System.out.println("Would not process sfter 3 tries. restart the program");
        System.exit(1);
    }

    AppTO getMyApp() throws Exception {
        if (!this.logedin) {
            return null;
        }
        boolean newApp = true;
        List<AppTO> apps = this.cs.getMyApps();
        if (apps.size() > 0) {
            newApp = false;
            System.out.println(" ========  apps ========= ");
            System.out.println("0 -- to create new app : ");
            System.out.println(" ======== exisiting apps ========= ");
            int i = 1;
            for (AppTO appTO : apps) {
                System.out.println(i++ + " -- to start app : " + appTO.name);
            }
            String option = this.systemIn("enter option : ");
            if (option.equals("0")) {
                newApp = true;
            } else {
                int opt = Integer.parseInt(option);
                this.currentApp = apps.get(opt - 1);
                System.out.println("selected app : " + this.currentApp.name);
            }
        }
        if (newApp) {
            AppTO to;
            String name = this.systemIn("enter name of your new app : ");
            this.currentApp = to = this.cs.createApp(name);
        }
        return this.currentApp;
    }

    String systemIn(String msg) {
        try {
            System.out.print(msg);
            BufferedReader bufferRead = new BufferedReader(new InputStreamReader(System.in));
            String input = bufferRead.readLine();
            return input;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tT:%4$s > %5$s%6$s%n");
        classMap = new HashMap();
    }
}

