/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.Baltoro;
import io.baltoro.client.CheckRequestFilter;
import io.baltoro.client.CheckResponseFilter;
import io.baltoro.to.AppTO;
import io.baltoro.to.BaseTO;
import io.baltoro.to.ContainerTO;
import io.baltoro.to.UserTO;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.jackson.JacksonFeature;

public class BOAPIClient {
    static Logger log = Logger.getLogger(BOAPIClient.class.getName());
    Client webClient = ((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).register(CheckRequestFilter.class)).register(CheckResponseFilter.class)).build();
    Cookie sessionCookie;
    String host = "http://api.baltoro.io";
    Baltoro baltoro;
    boolean online = false;

    BOAPIClient(Baltoro baltoro) {
        this.baltoro = baltoro;
        try {
            this.areYouThere();
            this.online = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.online = false;
        }
    }

    void areYouThere() throws Exception {
        String sessionId;
        log.info("... Are you There ...");
        WebTarget target = this.webClient.target(this.host).path("/baltoro/api/areyouthere");
        Invocation.Builder ib = this.getIB(target);
        Response response = ib.get();
        this.baltoro.sessionId = sessionId = response.readEntity(String.class);
        log.info("sessionId => " + sessionId);
        this.sessionCookie = new Cookie("JSESSIONID", sessionId, "/", null);
    }

    UserTO login(String email, String password) throws Exception {
        WebTarget target = this.webClient.target(this.host).path("/baltoro/api/auth/login");
        Form form = new Form();
        form.param("email", email);
        form.param("password", password);
        Invocation.Builder ib = this.getIB(target);
        Response response = ib.post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        UserTO user = response.readEntity(UserTO.class);
        return user;
    }

    Invocation.Builder getIB(WebTarget target) {
        Invocation.Builder ib = target.request(MediaType.APPLICATION_JSON_TYPE);
        if (this.sessionCookie != null) {
            ib.cookie(this.sessionCookie);
        }
        return ib;
    }

    ContainerTO createContainer() throws Exception {
        WebTarget target = this.webClient.target(this.host).path("/baltoro/api/bo/createContainer");
        Form form = new Form();
        form.param("name", "customer 1");
        Invocation.Builder ib = this.getIB(target);
        Response response = ib.post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        ContainerTO container = response.readEntity(ContainerTO.class);
        return container;
    }

    <T extends BaseTO> T getBO(String baseUuid, Class<T> type) throws Exception {
        String url = "/baltoro/api/bo/";
        if (type == ContainerTO.class) {
            url = url + "getContainer";
        } else if (type == UserTO.class) {
            url = url + "getUser";
        } else if (type == AppTO.class) {
            url = url + "getApp";
        }
        WebTarget target = this.webClient.target(this.host).path(url);
        target = target.queryParam("uuid", baseUuid);
        Invocation.Builder ib = this.getIB(target);
        Response response = ib.get();
        BaseTO bo = (BaseTO)response.readEntity(type);
        return (T)((BaseTO)type.cast(bo));
    }

    UserTO createUser(String email, String password) throws Exception {
        WebTarget target = this.webClient.target(this.host).path("/baltoro/api/bo/createUser");
        Form form = new Form();
        form.param("email", email);
        form.param("password", password);
        Invocation.Builder ib = this.getIB(target);
        Response response = ib.post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        UserTO user = response.readEntity(UserTO.class);
        return user;
    }

    AppTO createApp(String name) throws Exception {
        WebTarget target = this.webClient.target(this.host).path("/baltoro/api/bo/createApp");
        Form form = new Form();
        form.param("name", name);
        Invocation.Builder ib = this.getIB(target);
        Response response = ib.post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        AppTO app = response.readEntity(AppTO.class);
        return app;
    }

    List<AppTO> getMyApps() throws Exception {
        WebTarget target = this.webClient.target(this.host).path("/baltoro/api/bo/getMyApps");
        Form form = new Form();
        Invocation.Builder ib = this.getIB(target);
        Response response = ib.post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        List<AppTO> list = response.readEntity(new GenericType<List<AppTO>>(){});
        return list;
    }
}

