/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.AnnotationProcessor;
import io.baltoro.client.BOAPIClient;
import io.baltoro.client.BaltoroClientConfigurator;
import io.baltoro.client.BaltoroClientEndpoint;
import io.baltoro.client.BaltoroWSPing;
import io.baltoro.client.LocalDB;
import io.baltoro.client.OName;
import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.ep.ClassBuilder;
import io.baltoro.to.AppTO;
import io.baltoro.to.Keys;
import io.baltoro.to.UserTO;
import io.baltoro.util.CryptoUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.Session;
import javax.ws.rs.ProcessingException;
import org.glassfish.tyrus.client.ClientManager;

public class Baltoro {
    static Logger log = Logger.getLogger(Baltoro.class.getName());
    private static Map<String, Class<?>> classMap;
    private String appUuid;
    private String packages;
    private LocalDB db;
    private BOAPIClient cs;
    String privateKey;
    String publicKey;
    boolean logedin = false;
    private String email;
    private String password;
    String appPrivateKey;
    String appPublicKey;
    String sessionId;

    private Baltoro() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Session startClient() throws Exception {
        HashMap<String, WebMethod> pathMap = new HashMap<String, WebMethod>(200);
        AnnotationProcessor p = new AnnotationProcessor();
        for (String _package : this.packages.split(",")) {
            Map<String, WebMethod> pMap = p.processAnnotation(_package);
            pathMap.putAll(pMap);
        }
        WebMethodMap.getInstance().setMap(pathMap);
        ExecutorService executor = Executors.newWorkStealingPool();
        Future<Session> future = executor.submit(() -> {
            try {
                ClientManager clientManager = ClientManager.createClient();
                BaltoroClientConfigurator clientConfigurator = new BaltoroClientConfigurator(this.sessionId);
                ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator(clientConfigurator).build();
                BaltoroClientEndpoint instance = new BaltoroClientEndpoint(this.appUuid);
                Session session = clientManager.connectToServer(instance, config, new URI("ws://" + this.appUuid + ".baltoro.io/baltoro/ws"));
                return session;
            }
            catch (Exception e) {
                throw new IllegalStateException("task interrupted", e);
            }
        });
        Session session = future.get();
        BaltoroWSPing thread = new BaltoroWSPing(session);
        thread.start();
        log.info("got session --- 1 -- > " + session);
        return session;
    }

    public static <T> T EndPointFactory(Class<T> _class) {
        try {
            Class<?> implClass = classMap.get(_class.getName());
            if (implClass == null) {
                ClassBuilder builder = new ClassBuilder(_class);
                implClass = builder.buildClass();
                classMap.put(_class.getName(), implClass);
            }
            Object obj = implClass.newInstance();
            return (T)obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Session start() {
        try {
            Baltoro baltoro = new Baltoro();
            AppTO appTo = baltoro.getMyApp();
            baltoro.appUuid = appTo.uuid;
            baltoro.packages = "com";
            baltoro.appPrivateKey = appTo.privateKey;
            baltoro.appPublicKey = appTo.publicKey;
            Session session = baltoro.startClient();
            return session;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Baltoro.start();
    }

    void init() throws Exception {
        this.cs = new BOAPIClient(this);
        this.db = new LocalDB(this);
        boolean isSetup = this.db.isSetup();
        if (!isSetup) {
            this.setupDB();
            return;
        }
        for (int i = 0; i < 3; ++i) {
            this.password = this.systemIn("enter password to login (enter 0 to reset) : ");
            if (this.password.equals("0")) {
                this.db.cleanUp();
                System.out.println("cleanup complete restart the program");
                System.exit(1);
            }
            this.email = this.db.login(this.password);
            if (this.email != null) {
                UserTO userTO = this.cs.login(this.email, this.password);
                this.logedin = true;
                break;
            }
            System.out.println("wrong password, retry");
        }
        if (!this.logedin) {
            System.out.println("could not login");
            System.exit(1);
        }
    }

    private void setupDB() throws Exception {
        UserTO user = null;
        Keys keys = CryptoUtil.generateKeys();
        this.privateKey = keys.getPrivateKey();
        this.publicKey = keys.getPublicKey();
        String option = this.systemIn("enter 1 to signup : \nenter 2 to login : ");
        this.email = this.systemIn("email : ");
        this.password = this.systemIn("password : ");
        try {
            if (option.equals("1")) {
                user = this.cs.createUser(this.email, this.password);
            }
            user = this.cs.login(this.email, this.password);
            this.logedin = true;
            this.db.setup(user, this.password);
        }
        catch (ProcessingException e) {
            System.out.println(e.getMessage());
        }
    }

    AppTO getMyApp() throws Exception {
        if (!this.logedin) {
            return null;
        }
        String lastAppUuid = this.db.get(OName.APP_UUID);
        if (lastAppUuid != null) {
            String appPrivKey;
            String appPublicKey;
            AppTO appTO = new AppTO();
            appTO.uuid = lastAppUuid;
            appTO.publicKey = appPublicKey = this.db.get(OName.APP_PUBLIC_KEY);
            String _privKey = this.db.get(OName.APP_PRIVATE_KEY);
            appTO.privateKey = appPrivKey = CryptoUtil.decryptWithPassword(this.password, _privKey);
            return appTO;
        }
        boolean newApp = false;
        List<AppTO> apps = this.cs.getMyApps();
        AppTO selectedApp = null;
        if (apps.size() > 0) {
            System.out.println(" ========  apps ========= ");
            System.out.println("0 -- to create new app : ");
            System.out.println(" ======== exisiting apps ========= ");
            int i = 1;
            for (AppTO appTO : apps) {
                System.out.println(i++ + " -- to start app : " + appTO.name);
            }
            String option = this.systemIn("enter option : ");
            if (option.equals("0")) {
                newApp = true;
            } else {
                int opt = Integer.parseInt(option);
                selectedApp = apps.get(opt - 1);
                System.out.println("selected app : " + selectedApp.name);
            }
        }
        if (newApp) {
            AppTO to;
            String name = this.systemIn("create new app : ");
            selectedApp = to = this.cs.createApp(name);
        }
        this.db.save(OName.APP_UUID, selectedApp.uuid);
        String appPrivKey = CryptoUtil.encryptWithPassword(this.password, selectedApp.privateKey);
        this.db.save(OName.APP_PRIVATE_KEY, appPrivKey);
        this.db.save(OName.APP_PUBLIC_KEY, selectedApp.publicKey);
        return selectedApp;
    }

    String systemIn(String msg) {
        try {
            System.out.print(msg);
            BufferedReader bufferRead = new BufferedReader(new InputStreamReader(System.in));
            String input = bufferRead.readLine();
            return input;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tT:%4$s > %5$s%6$s%n");
        classMap = new HashMap();
    }
}

