/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.WebMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Path;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class AnnotationProcessor {
    static Logger log = Logger.getLogger(AnnotationProcessor.class.getName());

    public Map<String, WebMethod> processAnnotation(String packageName) throws Exception {
        log.info("packageName = " + packageName);
        Set<Class<?>> classes = AnnotationProcessor.getClasses(packageName);
        HashMap<String, WebMethod> pathMap = new HashMap<String, WebMethod>();
        for (Class<?> _class : classes) {
            Annotation[] annoArray;
            log.info("class = " + _class);
            for (Annotation anno : annoArray = _class.getAnnotations()) {
                if (anno instanceof Path) {
                    String cPath = ((Path)anno).value();
                    for (Method method : _class.getDeclaredMethods()) {
                        if (!method.isAnnotationPresent(Path.class)) continue;
                        Path mpath = method.getAnnotation(Path.class);
                        String fPath = cPath + mpath.value();
                        System.out.println("path --- >" + fPath + ", method --->" + method.getName());
                        WebMethod wm = new WebMethod(_class, method);
                        pathMap.put(fPath, wm);
                    }
                }
                if (!(anno instanceof RolesAllowed)) continue;
                RolesAllowed roleAnno = (RolesAllowed)anno;
                String[] roles = roleAnno.value();
                for (int i = 0; i < roles.length; ++i) {
                    System.out.println("role allowed" + roles[i]);
                }
            }
        }
        return pathMap;
    }

    static Set<Class<?>> getClasses(String packageName) throws Exception {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set<Class<?>> annotated = reflections.getTypesAnnotatedWith(Path.class);
        return annotated;
    }
}

