/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.grant;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.ballerina.messaging.broker.client.cmd.impl.grant.GrantCmd;
import io.ballerina.messaging.broker.client.resources.Permission;

@Parameters(commandDescription="Grant permissions to a exchange in the Broker")
public class GrantExchangeCmd
extends GrantCmd {
    @Parameter(description="name of the exchange", required=true)
    private String exchangeName;
    @Parameter(names={"--action", "-a"}, description="name of the action", required=true)
    private String action;
    @Parameter(names={"--group", "-g"}, description="name of the group", required=true)
    private String group;

    public GrantExchangeCmd(String rootCommand) {
        super(rootCommand);
    }

    @Override
    public void execute() {
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Permission permission = new Permission(this.action, this.group);
        String urlSuffix = "exchanges/" + this.exchangeName + "/permissions/actions/" + this.action + "/groups";
        this.performResourceCreationOverHttp(urlSuffix, permission.getUserGroupsAsJsonString(), "User groups successfully added.");
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " grant exchange [exchange-name]\n");
    }
}

