/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.transfer;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.ballerina.messaging.broker.client.cmd.impl.grant.GrantCmd;
import io.ballerina.messaging.broker.client.http.HttpClient;
import io.ballerina.messaging.broker.client.http.HttpRequest;
import io.ballerina.messaging.broker.client.http.HttpResponse;
import io.ballerina.messaging.broker.client.output.ResponseFormatter;
import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.resources.Message;
import io.ballerina.messaging.broker.client.utils.Utils;

@Parameters(commandDescription="Transfer ownership of a exchange in the Broker")
public class TransferExchangeCmd
extends GrantCmd {
    @Parameter(description="name of the exchange", required=true)
    private String exchange;
    @Parameter(names={"--new-owner", "-n"}, description="user id of the new owner", required=true)
    private String newOwner;

    public TransferExchangeCmd(String rootCommand) {
        super(rootCommand);
    }

    @Override
    public void execute() {
        HttpRequest httpRequest;
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Configuration configuration = Utils.getConfiguration(this.password);
        HttpClient httpClient = new HttpClient(configuration);
        HttpResponse response = httpClient.sendHttpRequest(httpRequest = new HttpRequest("exchanges/" + this.exchange + "/permissions/owner", this.getJsonRequestPayload()), "PUT");
        if (response.getStatusCode() == 204) {
            Message message = new Message("Exchage ownership transferred successfully");
            ResponseFormatter.printMessage(message);
        } else {
            ResponseFormatter.handleErrorResponse(this.buildResponseMessage(response, "Error while invoking Brokers admin services"));
        }
    }

    private String getJsonRequestPayload() {
        return "{\"owner\":\"" + this.newOwner + "\"}";
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " revoke queue [queue-name]\n");
    }
}

