/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.revoke;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.ballerina.messaging.broker.client.cmd.impl.grant.GrantCmd;
import io.ballerina.messaging.broker.client.http.HttpClient;
import io.ballerina.messaging.broker.client.http.HttpRequest;
import io.ballerina.messaging.broker.client.http.HttpResponse;
import io.ballerina.messaging.broker.client.output.ResponseFormatter;
import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.resources.Message;
import io.ballerina.messaging.broker.client.utils.Utils;

@Parameters(commandDescription="Revoke permissions to a exchange in the Broker")
public class RevokeExchangeCmd
extends GrantCmd {
    @Parameter(description="name of the exchange", required=true)
    private String exchangeName;
    @Parameter(names={"--action", "-a"}, description="name of the action", required=true)
    private String action;
    @Parameter(names={"--group", "-g"}, description="name of the group", required=true)
    private String group;

    public RevokeExchangeCmd(String rootCommand) {
        super(rootCommand);
    }

    @Override
    public void execute() {
        HttpRequest httpRequest;
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Configuration configuration = Utils.getConfiguration(this.password);
        HttpClient httpClient = new HttpClient(configuration);
        HttpResponse response = httpClient.sendHttpRequest(httpRequest = new HttpRequest("exchanges/" + this.exchangeName + "/permissions/actions/" + this.action + "/groups" + "/" + this.group), "DELETE");
        if (response.getStatusCode() == 200) {
            Message message = this.buildResponseMessage(response, "Exchange permission revoked successfully");
            ResponseFormatter.printMessage(message);
        } else {
            ResponseFormatter.handleErrorResponse(this.buildResponseMessage(response, "Error while invoking Brokers admin services"));
        }
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " revoke queue [queue-name]\n");
    }
}

