/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.create;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.ballerina.messaging.broker.client.cmd.impl.create.CreateCmd;
import io.ballerina.messaging.broker.client.resources.Queue;

@Parameters(commandDescription="Create a queue in the Broker with parameters")
public class CreateQueueCmd
extends CreateCmd {
    @Parameter(description="name of the queue", required=true)
    private String queueName;
    @Parameter(names={"--autoDelete", "-a"}, description="is auto delete enabled")
    private boolean autoDelete = false;
    @Parameter(names={"--durable", "-d"}, description="durability of the queue")
    private boolean durable = false;

    public CreateQueueCmd(String rootCommand) {
        super(rootCommand, "Queue created successfully");
    }

    @Override
    public void execute() {
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Queue queue = new Queue(this.queueName, this.autoDelete, this.durable);
        this.performResourceCreationOverHttp("queues/", queue.getAsJsonString());
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " create queue [queue-name] [flag]*\n");
    }
}

