/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.utils;

import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.utils.BrokerClientException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Utils {
    public static BrokerClientException createUsageException(String errorMsg, String rootCommand) {
        BrokerClientException brokerClientException = new BrokerClientException();
        brokerClientException.addMessage(rootCommand + ": " + errorMsg);
        brokerClientException.addMessage("Run '" + rootCommand + " --help' for usage.");
        return brokerClientException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Configuration readConfigurationFile() {
        Yaml yaml = new Yaml();
        try (FileInputStream in = new FileInputStream(Utils.getConfigFilePath());){
            Configuration configuration = (Configuration)yaml.loadAs((InputStream)in, Configuration.class);
            if (!Configuration.validateConfiguration(configuration)) {
                BrokerClientException exception = new BrokerClientException();
                exception.addMessage("Error in the CLI client configuration");
                exception.addMessage("Please re-initialize using 'init' command");
                throw exception;
            }
            Configuration configuration2 = configuration;
            return configuration2;
        }
        catch (IOException e) {
            BrokerClientException brokerClientException = new BrokerClientException();
            brokerClientException.addMessage("error when reading the configuration file. " + e.getMessage());
            throw brokerClientException;
        }
    }

    public static Configuration getConfiguration(String password) {
        Configuration configuration = Utils.readConfigurationFile();
        if (Objects.nonNull(password)) {
            configuration.setPassword(password);
        }
        if (Objects.isNull(configuration.getPassword())) {
            BrokerClientException exception = new BrokerClientException();
            exception.addMessage("User password is not provided.");
            exception.addMessage("Setup the password at global level using 'init' command or provide password when executing each command using (--password|-p) flag");
            throw exception;
        }
        return configuration;
    }

    public static void createConfigurationFile(Configuration configuration) {
        DumperOptions options = new DumperOptions();
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(Utils.getConfigFilePath()), StandardCharsets.UTF_8);){
            yaml.dump((Object)configuration, (Writer)writer);
        }
        catch (IOException e) {
            BrokerClientException brokerClientException = new BrokerClientException();
            brokerClientException.addMessage("error when creating the configuration file. " + e.getMessage());
            throw brokerClientException;
        }
    }

    private static String getConfigFilePath() {
        String path = System.getProperty("client.cli.conf");
        if (path != null && !path.trim().isEmpty()) {
            return path;
        }
        return "cli-config.yml";
    }
}

