/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.list;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.Gson;
import io.ballerina.messaging.broker.client.cmd.impl.list.ListCmd;
import io.ballerina.messaging.broker.client.http.HttpClient;
import io.ballerina.messaging.broker.client.http.HttpRequest;
import io.ballerina.messaging.broker.client.http.HttpResponse;
import io.ballerina.messaging.broker.client.output.ResponseFormatter;
import io.ballerina.messaging.broker.client.output.TableFormatter;
import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.resources.Consumer;
import io.ballerina.messaging.broker.client.utils.Utils;

@Parameters(commandDescription="List consumers in a Broker queue")
public class ListConsumerCmd
extends ListCmd {
    @Parameter(names={"--all", "-a"}, description="return info on all consumer of the queue")
    private boolean all;
    @Parameter(names={"--consumer", "-c"}, description="id of the consumer which info needs to be retrieved")
    private String consumerId = "";
    @Parameter(description="name of the queue", required=true)
    private String queueName = "";

    public ListConsumerCmd(String rootCommand) {
        super(rootCommand);
    }

    @Override
    public void execute() {
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Configuration configuration = Utils.getConfiguration(this.password);
        HttpClient httpClient = new HttpClient(configuration);
        if (this.all) {
            this.consumerId = "";
        }
        HttpRequest httpRequest = new HttpRequest("queues/" + this.queueName + "/consumers/" + this.consumerId);
        HttpResponse response = httpClient.sendHttpRequest(httpRequest, "GET");
        TableFormatter responseFormatter = new TableFormatter();
        if (response.getStatusCode() == 200) {
            Gson gson = new Gson();
            Consumer[] consumers = this.consumerId.isEmpty() ? (Consumer[])gson.fromJson(response.getPayload(), Consumer[].class) : new Consumer[]{(Consumer)gson.fromJson(response.getPayload(), Consumer.class)};
            responseFormatter.printConsumers(consumers);
        } else {
            ResponseFormatter.handleErrorResponse(this.buildResponseMessage(response, "Error while invoking Brokers admin services"));
        }
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " list consumer [queue-name] [flag]*\n");
    }
}

