/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.output;

import io.ballerina.messaging.broker.client.output.ResponseFormatter;
import io.ballerina.messaging.broker.client.resources.Binding;
import io.ballerina.messaging.broker.client.resources.Consumer;
import io.ballerina.messaging.broker.client.resources.Exchange;
import io.ballerina.messaging.broker.client.resources.Queue;

public class CsvFormatter
implements ResponseFormatter {
    public static final String WRAPPED_STRING_FORMATTER = "\"%s\"";
    private static final String FORMATTER_NAME = "csv";

    @Override
    public void printExchanges(Exchange[] exchanges) {
        if (exchanges.length == 0) {
            return;
        }
        String printTemplate = "%s,%s,%s,%s%n";
        OUT_STREAM.printf(printTemplate, "name", "type", "durable", "owner");
        for (Exchange exchange : exchanges) {
            OUT_STREAM.printf(printTemplate.replaceFirst("%s", WRAPPED_STRING_FORMATTER), exchange.getName(), exchange.getType(), String.valueOf(exchange.isDurable()), exchange.getOwner());
        }
    }

    @Override
    public void printExchange(Exchange exchange) {
        this.printExchanges(new Exchange[]{exchange});
    }

    @Override
    public void printQueues(Queue[] queues) {
        if (queues.length == 0) {
            return;
        }
        String printTemplate = "%s,%s,%s,%s,%s,%s,%s%n";
        OUT_STREAM.printf(printTemplate, "name", "consumerCount", "capacity", "size", "durable", "autoDelete", "owner");
        for (Queue queue : queues) {
            OUT_STREAM.printf(printTemplate.replaceFirst("%s", WRAPPED_STRING_FORMATTER), queue.getName(), String.valueOf(queue.getConsumerCount()), String.valueOf(queue.getCapacity()), String.valueOf(queue.getSize()), String.valueOf(queue.isDurable()), String.valueOf(queue.isAutoDelete()), queue.getOwner());
        }
    }

    @Override
    public void printQueue(Queue queues) {
        this.printQueues(new Queue[]{queues});
    }

    @Override
    public void printExchangeBindings(Binding[] bindings) {
        if (bindings.length == 0) {
            return;
        }
        String printTemplate = "%s,%s%n";
        OUT_STREAM.printf(printTemplate, "queueName", "bindingPattern");
        for (Binding binding : bindings) {
            OUT_STREAM.printf(printTemplate.replace("%s", WRAPPED_STRING_FORMATTER), binding.getQueueName(), binding.getBindingPattern());
        }
    }

    @Override
    public void printConsumers(Consumer[] consumers) {
        if (consumers.length == 0) {
            return;
        }
        String printTemplate = "%s,%s,%s%n";
        OUT_STREAM.printf(printTemplate, "id", "isExclusive", "flowEnabled");
        for (Consumer consumer : consumers) {
            OUT_STREAM.printf(printTemplate, consumer.getId(), consumer.isExclusive(), consumer.isFlowEnabled());
        }
    }

    public String toString() {
        return FORMATTER_NAME;
    }
}

