/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.create;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.ballerina.messaging.broker.client.cmd.impl.create.CreateCmd;
import io.ballerina.messaging.broker.client.resources.Binding;
import java.util.Objects;

@Parameters(commandDescription="Create a binding in the Broker with parameters")
public class CreateBindingCmd
extends CreateCmd {
    @Parameter(description="binding key (queue name is used if not present)")
    private String bindingPattern = null;
    @Parameter(names={"--exchange", "-e"}, description="name of the exchange", required=true)
    private String exchangeName;
    @Parameter(names={"--queue", "-q"}, description="name of the queue", required=true)
    private String queueName;
    @Parameter(names={"--filter", "-f"}, description="filter expression")
    private String filterExpression = "";

    public CreateBindingCmd(String rootCommand) {
        super(rootCommand, "Binding created successfully");
    }

    @Override
    public void execute() {
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        if (Objects.isNull(this.bindingPattern)) {
            this.bindingPattern = this.queueName;
        }
        Binding binding = new Binding(this.queueName, this.bindingPattern, this.exchangeName, this.filterExpression);
        this.performResourceCreationOverHttp("queues/" + binding.getQueueName() + "/bindings/", binding.getAsJsonString());
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " create binding [binding-pattern]? -e [exchange-name] -q [queue-name] [other-flags]*\n");
    }
}

