/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.ballerina.messaging.broker.client.cmd.AbstractCmd;
import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.utils.Utils;

@Parameters(commandDescription="Initialize the Broker CLI Client by providing HTTP connection details and user credentials")
public class InitCmd
extends AbstractCmd {
    @Parameter(names={"--host", "-H"}, description="Broker admin service hostname")
    private String hostname = "127.0.0.1";
    @Parameter(names={"--port", "-P"}, description="Broker admin service port")
    private int port = 9000;
    @Parameter(names={"--username", "-u"}, description="Username")
    private String username = "admin";

    public InitCmd(String rootCommand) {
        super(rootCommand);
    }

    @Override
    public void execute() {
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Configuration configuration = new Configuration(this.hostname, this.port, this.username, this.password);
        Utils.createConfigurationFile(configuration);
        String message = "Initialized Broker CLI client with hostname: " + this.hostname + ", port: " + this.port + ", username: " + this.username;
        ERR_STREAM.println(message);
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " init [flag]*\n");
    }
}

