/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.output;

import io.ballerina.messaging.broker.client.output.ResponseFormatter;
import io.ballerina.messaging.broker.client.resources.Binding;
import io.ballerina.messaging.broker.client.resources.Consumer;
import io.ballerina.messaging.broker.client.resources.Exchange;
import io.ballerina.messaging.broker.client.resources.Queue;
import java.util.Arrays;

public class TableFormatter
implements ResponseFormatter {
    public static final int TABLE_PADDING = 2;
    private static final String FORMATTER_NAME = "table";

    @Override
    public void printExchanges(Exchange[] exchanges) {
        if (exchanges.length == 0) {
            return;
        }
        int maxExchangeNameLength = Arrays.stream(exchanges).mapToInt(exchange -> exchange.getName().length()).max().getAsInt();
        int maxColumnSize = Math.max(maxExchangeNameLength, "name".length());
        String printTemplate = "%-" + String.valueOf(maxColumnSize + 2) + "s%-10s%-10s\n";
        OUT_STREAM.printf(printTemplate, "name", "type", "durable");
        for (Exchange exchange2 : exchanges) {
            OUT_STREAM.printf(printTemplate, exchange2.getName(), exchange2.getType(), String.valueOf(exchange2.isDurable()));
        }
    }

    @Override
    public void printQueues(Queue[] queues) {
        if (queues.length == 0) {
            return;
        }
        int maxQueueNameLength = Arrays.stream(queues).mapToInt(queue -> queue.getName().length()).max().getAsInt();
        int maxColumnSize = Math.max(maxQueueNameLength, "name".length());
        String printTemplate = "%-" + String.valueOf(maxColumnSize + 2) + "s%-15s%-15s%-10s%-10s%-10s\n";
        OUT_STREAM.printf(printTemplate, "name", "consumerCount", "capacity", "size", "durable", "autoDelete");
        for (Queue queue2 : queues) {
            OUT_STREAM.printf(printTemplate, queue2.getName(), String.valueOf(queue2.getConsumerCount()), String.valueOf(queue2.getCapacity()), String.valueOf(queue2.getSize()), String.valueOf(queue2.isDurable()), String.valueOf(queue2.isAutoDelete()));
        }
    }

    @Override
    public void printExchangeBindings(Binding[] bindings) {
        if (bindings.length == 0) {
            return;
        }
        int maxQueueNameLength = Arrays.stream(bindings).mapToInt(binding -> binding.getQueueName().length()).max().getAsInt();
        int maxColumnSize = Math.max(maxQueueNameLength, "queueName".length());
        String printTemplate = "%-" + String.valueOf(maxColumnSize + 2) + "s%s\n";
        OUT_STREAM.printf(printTemplate, "queueName", "bindingPattern");
        for (Binding binding2 : bindings) {
            OUT_STREAM.printf(printTemplate, binding2.getQueueName(), binding2.getBindingPattern());
        }
    }

    @Override
    public void printConsumers(Consumer[] consumers) {
        if (consumers.length == 0) {
            return;
        }
        int maxIdLength = Arrays.stream(consumers).mapToInt(consumer -> String.valueOf(consumer.getId()).length()).max().getAsInt();
        int maxColumnSize = Math.max(maxIdLength, "id".length());
        String printTemplate = "%-" + String.valueOf(maxColumnSize + 2) + "s%-12s%s\n";
        OUT_STREAM.printf(printTemplate, "id", "isExclusive", "flowEnabled");
        for (Consumer consumer2 : consumers) {
            OUT_STREAM.printf(printTemplate, consumer2.getId(), consumer2.isExclusive(), consumer2.isFlowEnabled());
        }
    }

    public String toString() {
        return FORMATTER_NAME;
    }
}

