/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.list;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.Gson;
import io.ballerina.messaging.broker.client.cmd.impl.list.ListCmd;
import io.ballerina.messaging.broker.client.http.HttpClient;
import io.ballerina.messaging.broker.client.http.HttpRequest;
import io.ballerina.messaging.broker.client.http.HttpResponse;
import io.ballerina.messaging.broker.client.output.ResponseFormatter;
import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.resources.Queue;
import io.ballerina.messaging.broker.client.utils.Utils;

@Parameters(commandDescription="List queue(s) in the Broker")
public class ListQueueCmd
extends ListCmd {
    @Parameter(names={"--all", "-a"}, description="return info on all queues of the broker")
    private boolean all;
    @Parameter(description="name of the queue which info needs to be retrieved")
    private String queueName = "";

    public ListQueueCmd(String rootCommand) {
        super(rootCommand);
    }

    @Override
    public void execute() {
        HttpRequest httpRequest;
        HttpResponse response;
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Configuration configuration = Utils.getConfiguration(this.password);
        HttpClient httpClient = new HttpClient(configuration);
        if (this.all) {
            this.queueName = "";
        }
        if ((response = httpClient.sendHttpRequest(httpRequest = new HttpRequest("queues/" + this.queueName), "GET")).getStatusCode() == 200) {
            Gson gson = new Gson();
            Queue[] queues = this.queueName.isEmpty() ? (Queue[])gson.fromJson(response.getPayload(), Queue[].class) : new Queue[]{(Queue)gson.fromJson(response.getPayload(), Queue.class)};
            this.responseFormatter.printQueues(queues);
        } else {
            ResponseFormatter.handleErrorResponse(this.buildResponseMessage(response, "Error while invoking Brokers admin services"));
        }
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " list queue [queue-name]? [flag]*\n");
    }
}

