/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.list;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.Gson;
import io.ballerina.messaging.broker.client.cmd.impl.list.ListCmd;
import io.ballerina.messaging.broker.client.http.HttpClient;
import io.ballerina.messaging.broker.client.http.HttpRequest;
import io.ballerina.messaging.broker.client.http.HttpResponse;
import io.ballerina.messaging.broker.client.output.ResponseFormatter;
import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.resources.Exchange;
import io.ballerina.messaging.broker.client.utils.Utils;

@Parameters(commandDescription="List exchange(s) in the Broker")
public class ListExchangeCmd
extends ListCmd {
    @Parameter(names={"--all", "-a"}, description="return info on all exchanges of the broker")
    private boolean all;
    @Parameter(description="name of the exchange which info needs to be retrieved")
    private String exchangeName = "";

    public ListExchangeCmd(String rootCommand) {
        super(rootCommand);
    }

    @Override
    public void execute() {
        HttpRequest httpRequest;
        HttpResponse response;
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Configuration configuration = Utils.getConfiguration(this.password);
        HttpClient httpClient = new HttpClient(configuration);
        if (this.all) {
            this.exchangeName = "";
        }
        if ((response = httpClient.sendHttpRequest(httpRequest = new HttpRequest("exchanges/" + this.exchangeName), "GET")).getStatusCode() == 200) {
            Gson gson = new Gson();
            Exchange[] exchanges = this.exchangeName.isEmpty() ? (Exchange[])gson.fromJson(response.getPayload(), Exchange[].class) : new Exchange[]{(Exchange)gson.fromJson(response.getPayload(), Exchange.class)};
            this.responseFormatter.printExchanges(exchanges);
        } else {
            ResponseFormatter.handleErrorResponse(this.buildResponseMessage(response, "Error while invoking Brokers admin services"));
        }
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " list exchange [exchange-name]? [flag]*\n");
    }
}

