/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.list;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import io.ballerina.messaging.broker.client.cmd.impl.list.ListCmd;
import io.ballerina.messaging.broker.client.http.HttpClient;
import io.ballerina.messaging.broker.client.http.HttpRequest;
import io.ballerina.messaging.broker.client.http.HttpResponse;
import io.ballerina.messaging.broker.client.output.ResponseFormatter;
import io.ballerina.messaging.broker.client.resources.Binding;
import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.utils.BrokerClientException;
import io.ballerina.messaging.broker.client.utils.Utils;
import java.util.ArrayList;

@Parameters(commandDescription="List Binding(s) in the Broker for a queue or an exchange")
public class ListBindingCmd
extends ListCmd {
    @Parameter(names={"--exchange", "-e"}, description="name of the exchange (only one from 'queue' name and 'exchange' name should be provided)")
    private String exchangeName = "";
    @Parameter(names={"--queue", "-q"}, description="name of the queue (only one from 'queue' name and 'exchange' name should be provided)")
    private String queueName = "";

    public ListBindingCmd(String rootCommand) {
        super(rootCommand);
    }

    @Override
    public void execute() {
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        if (!this.queueName.isEmpty() && !this.exchangeName.isEmpty()) {
            BrokerClientException exception = new BrokerClientException();
            exception.addMessage("either one from 'queue' name and 'exchange' name should only be present");
            throw exception;
        }
        if (!this.queueName.isEmpty()) {
            BrokerClientException exception = new BrokerClientException();
            exception.addMessage("listing bindings of a particular queue is not supported yet");
            throw exception;
        }
        Configuration configuration = Utils.getConfiguration(this.password);
        HttpClient httpClient = new HttpClient(configuration);
        String urlParamType = !this.exchangeName.isEmpty() ? "exchanges/" : "queues/";
        String urlParamName = !this.exchangeName.isEmpty() ? this.exchangeName : this.queueName;
        HttpRequest httpRequest = new HttpRequest(urlParamType + urlParamName + "/bindings/");
        HttpResponse response = httpClient.sendHttpRequest(httpRequest, "GET");
        if (response.getStatusCode() == 200) {
            if (!this.exchangeName.isEmpty()) {
                Binding[] bindings = this.processExchangeResponse(response.getPayload(), this.exchangeName);
                this.responseFormatter.printExchangeBindings(bindings);
            }
        } else {
            ResponseFormatter.handleErrorResponse(this.buildResponseMessage(response, "Error while invoking Brokers admin services"));
        }
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " list binding (--exchange|--queue) [resource-name] [flag]*\n");
    }

    private Binding[] processExchangeResponse(String payload, String exchangeName) {
        JsonParser parser = new JsonParser();
        JsonArray json = parser.parse(payload).getAsJsonArray();
        ArrayList bindings = new ArrayList();
        json.forEach(jsonElement -> {
            String bindingPatten = jsonElement.getAsJsonObject().get("bindingPattern").getAsString();
            JsonArray internalArray = jsonElement.getAsJsonObject().getAsJsonArray("bindings");
            internalArray.forEach(resource -> {
                String bindQueueName = resource.getAsJsonObject().get("queueName").getAsString();
                bindings.add(new Binding(bindQueueName, bindingPatten, exchangeName, ""));
            });
        });
        return bindings.toArray(new Binding[bindings.size()]);
    }
}

