/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.delete;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.ballerina.messaging.broker.client.cmd.impl.delete.DeleteCmd;
import io.ballerina.messaging.broker.client.http.HttpClient;
import io.ballerina.messaging.broker.client.http.HttpRequest;
import io.ballerina.messaging.broker.client.http.HttpResponse;
import io.ballerina.messaging.broker.client.output.ResponseFormatter;
import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.resources.Message;
import io.ballerina.messaging.broker.client.utils.Utils;

@Parameters(commandDescription="Delete a queue in the Broker")
public class DeleteQueueCmd
extends DeleteCmd {
    @Parameter(description="name of the queue", required=true)
    private String queueName;
    @Parameter(names={"--unused", "-u"}, description="delete only if the queue is not in use")
    private boolean ifUnused = false;
    @Parameter(names={"--empty", "-e"}, description="delete only if the queue is empty")
    private boolean ifEmpty = false;

    public DeleteQueueCmd(String rootCommand) {
        super(rootCommand);
    }

    @Override
    public void execute() {
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Configuration configuration = Utils.getConfiguration(this.password);
        HttpClient httpClient = new HttpClient(configuration);
        HttpRequest httpRequest = new HttpRequest("queues/" + this.queueName);
        httpRequest.setQueryParameters("?ifUnused=" + String.valueOf(this.ifUnused) + "&ifEmpty=" + String.valueOf(this.ifEmpty));
        HttpResponse response = httpClient.sendHttpRequest(httpRequest, "DELETE");
        if (response.getStatusCode() == 200) {
            Message message = this.buildResponseMessage(response, "Queue deleted successfully");
            ResponseFormatter.printMessage(message);
        } else {
            ResponseFormatter.handleErrorResponse(this.buildResponseMessage(response, "Error while invoking Brokers admin services"));
        }
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " delete queue [queue-name] [flag]*\n");
    }
}

