/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.delete;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.ballerina.messaging.broker.client.cmd.impl.delete.DeleteCmd;
import io.ballerina.messaging.broker.client.http.HttpClient;
import io.ballerina.messaging.broker.client.http.HttpRequest;
import io.ballerina.messaging.broker.client.http.HttpResponse;
import io.ballerina.messaging.broker.client.output.ResponseFormatter;
import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.resources.Message;
import io.ballerina.messaging.broker.client.utils.Utils;

@Parameters(commandDescription="Delete an exchange in the Broker")
public class DeleteExchangeCmd
extends DeleteCmd {
    @Parameter(description="name of the exchange", required=true)
    private String exchangeName;
    @Parameter(names={"--unused", "-u"}, description="delete only if the exchange is not in use")
    private boolean ifUnused = false;

    public DeleteExchangeCmd(String rootCommand) {
        super(rootCommand);
    }

    @Override
    public void execute() {
        HttpResponse response;
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Configuration configuration = Utils.getConfiguration(this.password);
        HttpClient httpClient = new HttpClient(configuration);
        HttpRequest httpRequest = new HttpRequest("exchanges/" + this.exchangeName);
        if (this.ifUnused) {
            httpRequest.setQueryParameters("?ifUnused=true");
        }
        if ((response = httpClient.sendHttpRequest(httpRequest, "DELETE")).getStatusCode() == 200) {
            Message message = this.buildResponseMessage(response, "Exchange deleted successfully");
            ResponseFormatter.printMessage(message);
        } else {
            ResponseFormatter.handleErrorResponse(this.buildResponseMessage(response, "Error while invoking Brokers admin services"));
        }
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " delete exchange [exchange-name] [flag]*\n");
    }
}

