/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.create;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.ballerina.messaging.broker.client.cmd.impl.create.CreateCmd;
import io.ballerina.messaging.broker.client.resources.Exchange;

@Parameters(commandDescription="Create an exchange in the Broker with parameters")
public class CreateExchangeCmd
extends CreateCmd {
    @Parameter(description="name of the exchange", required=true)
    private String exchangeName;
    @Parameter(names={"--type", "-t"}, description="type of the exchange")
    private String type = "direct";
    @Parameter(names={"--durable", "-d"}, description="durability of the exchange")
    private boolean durable = false;

    public CreateExchangeCmd(String rootCommand) {
        super(rootCommand, "Exchange created successfully");
    }

    @Override
    public void execute() {
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Exchange exchange = new Exchange(this.exchangeName, this.type, this.durable);
        this.performResourceCreationOverHttp("exchanges/", exchange.getAsJsonString());
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " create exchange [exchange-name] [flag]*\n");
    }
}

