/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.create;

import com.beust.jcommander.Parameters;
import io.ballerina.messaging.broker.client.cmd.AbstractCmd;
import io.ballerina.messaging.broker.client.http.HttpClient;
import io.ballerina.messaging.broker.client.http.HttpRequest;
import io.ballerina.messaging.broker.client.http.HttpResponse;
import io.ballerina.messaging.broker.client.output.ResponseFormatter;
import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.resources.Message;
import io.ballerina.messaging.broker.client.utils.Utils;

@Parameters(commandDescription="Create a resource in the Broker with parameters")
public class CreateCmd
extends AbstractCmd {
    private String defaultSuccessMessage;

    public CreateCmd(String rootCommand) {
        super(rootCommand);
    }

    public CreateCmd(String rootCommand, String defaultSuccessMessage) {
        super(rootCommand);
        this.defaultSuccessMessage = defaultSuccessMessage;
    }

    @Override
    public void execute() {
        if (!this.help) {
            throw Utils.createUsageException("a command is expected after 'create'", this.rootCommand);
        }
        this.processHelpLogs();
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " create [command]\n");
    }

    void performResourceCreationOverHttp(String urlSuffix, String payload) {
        HttpRequest httpRequest;
        Configuration configuration = Utils.getConfiguration(this.password);
        HttpClient httpClient = new HttpClient(configuration);
        HttpResponse response = httpClient.sendHttpRequest(httpRequest = new HttpRequest(urlSuffix, payload), "POST");
        if (response.getStatusCode() == 201) {
            Message message = this.buildResponseMessage(response, this.defaultSuccessMessage);
            ResponseFormatter.printMessage(message);
        } else {
            ResponseFormatter.handleErrorResponse(this.buildResponseMessage(response, "Error while invoking Brokers admin services"));
        }
    }
}

