/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.ballerina.messaging.broker.client.cmd.MBClientCmd;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractCmd
implements MBClientCmd {
    protected static final PrintStream ERR_STREAM = System.err;
    private static final int LOGS_PADDING = 2;
    protected String rootCommand;
    protected JCommander selfJCommander;
    @Parameter(names={"--help", "-h"}, help=true, hidden=true, description="Ask for help")
    protected boolean help;
    @Parameter(names={"--verbose", "-v"}, hidden=true, description="Enable verbose mode")
    protected boolean verbose;

    protected AbstractCmd(String rootCommand) {
        this.rootCommand = rootCommand;
    }

    static void appendCommandDescription(JCommander jCommander, StringBuilder sb) {
        MBClientCmd selfCommand = (MBClientCmd)jCommander.getObjects().get(0);
        if (selfCommand.getClass().getAnnotations().length == 0) {
            return;
        }
        Parameters parameters = (Parameters)selfCommand.getClass().getAnnotations()[0];
        String commandDescription = parameters.commandDescription();
        sb.append(commandDescription);
        sb.append("\n\n");
    }

    private static void appendChildCommandsInfo(JCommander jCommander, StringBuilder sb) {
        Map commandMap = jCommander.getCommands();
        if (commandMap.isEmpty()) {
            return;
        }
        int maxLength = jCommander.getCommands().keySet().stream().mapToInt(String::length).max().orElse(15);
        sb.append("Commands:\n");
        jCommander.getCommands().keySet().forEach(key -> {
            sb.append(String.format("%2s%-" + String.valueOf(maxLength + 2) + "s", "", key));
            sb.append(jCommander.getCommandDescription(key));
            sb.append("\n");
        });
        sb.append("\n");
    }

    private static void appendFlagsInfo(JCommander jCommander, StringBuilder sb) {
        List params = jCommander.getParameters().stream().filter(param -> !param.getParameter().hidden()).collect(Collectors.toList());
        if (params.isEmpty()) {
            return;
        }
        int maxLength = params.stream().mapToInt(param -> param.getNames().length()).max().orElse(15);
        sb.append("Flags:\n");
        params.stream().filter(param -> !param.getParameter().hidden()).forEach(param -> {
            sb.append(String.format("%2s%-" + String.valueOf(maxLength + 2) + "s", "", param.getNames()));
            sb.append(param.getDescription());
            sb.append(" (default: ");
            sb.append(param.getDefault());
            sb.append(")\n");
        });
        sb.append("\n");
    }

    private static void appendGlobalFlagsInfo(StringBuilder sb) {
        int maxLength = 0;
        HashMap<String, String> globalFlags = new HashMap<String, String>();
        for (Field field : AbstractCmd.class.getDeclaredFields()) {
            Parameter param = field.getAnnotation(Parameter.class);
            if (Objects.isNull(param)) continue;
            String key = String.join((CharSequence)",", param.names());
            maxLength = Math.max(maxLength, key.length());
            globalFlags.put(key, param.description());
        }
        sb.append("Global Flags:\n");
        int finalMaxLength = maxLength;
        globalFlags.keySet().forEach(flag -> {
            sb.append(String.format("%2s%-" + String.valueOf(finalMaxLength + 2) + "s", "", flag));
            sb.append((String)globalFlags.get(flag));
            sb.append("\n");
        });
    }

    @Override
    public void setSelfJCommander(JCommander selfJCommander) {
        this.selfJCommander = selfJCommander;
    }

    protected void processHelpLogs() {
        StringBuilder sb = new StringBuilder();
        AbstractCmd.appendCommandDescription(this.selfJCommander, sb);
        this.appendUsage(sb);
        sb.append("\n");
        AbstractCmd.appendChildCommandsInfo(this.selfJCommander, sb);
        AbstractCmd.appendFlagsInfo(this.selfJCommander, sb);
        AbstractCmd.appendGlobalFlagsInfo(sb);
        ERR_STREAM.println(sb.toString());
    }
}

