/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.resources;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

public class Configuration {
    private String hostname;
    private int port = -1;
    private String username;
    private String password;

    public Configuration() {
    }

    public Configuration(String hostname, int port, String username, String password) {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public static boolean validateConfiguration(Configuration configuration) {
        return Objects.nonNull(configuration.getHostname()) && configuration.getPort() != -1 && Objects.nonNull(configuration.getUsername()) && Objects.nonNull(configuration.getPassword());
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEncodedCredentials() {
        return Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8));
    }

    public String getUrl() {
        return "https://" + this.hostname + ":" + String.valueOf(this.port);
    }
}

