/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.http;

import io.ballerina.messaging.broker.client.http.HttpRequest;
import io.ballerina.messaging.broker.client.http.HttpResponse;
import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.utils.BrokerClientException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpClient {
    private static final String USER_AGENT = "Broker-CLI-Client/4.0";
    private String url;
    private String encodedCredentials;

    public HttpClient(Configuration configuration) {
        this.url = configuration.getUrl() + "/broker/v1.0/";
        this.encodedCredentials = configuration.getEncodedCredentials();
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509UntrustManagerImpl()};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = (hostname, session) -> true;
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            BrokerClientException exception = new BrokerClientException();
            exception.addMessage("error initializing the connection");
            exception.addMessage(e.getMessage());
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponse sendHttpRequest(HttpRequest request, String httpMethod) {
        try {
            URL obj = new URL(this.url + request.getSuffix());
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setRequestMethod(httpMethod);
            con.setRequestProperty("User-Agent", USER_AGENT);
            con.setRequestProperty("Accept", "application/json");
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Authorization", "Basic" + this.encodedCredentials);
            if (Objects.nonNull(request.getQueryParameters()) || Objects.nonNull(request.getPayload())) {
                con.setDoOutput(true);
                DataOutputStream wr = null;
                try {
                    wr = new DataOutputStream(con.getOutputStream());
                    if (Objects.nonNull(request.getQueryParameters())) {
                        wr.writeBytes(request.getQueryParameters());
                    }
                    if (Objects.nonNull(request.getPayload())) {
                        wr.writeBytes(request.getPayload());
                    }
                }
                finally {
                    if (Objects.nonNull(wr)) {
                        wr.flush();
                        wr.close();
                    }
                }
            }
            int responseCode = con.getResponseCode();
            StringBuilder response = new StringBuilder();
            try (BufferedReader in = null;){
                String inputLine;
                if (responseCode / 100 == 4 || responseCode / 100 == 5) {
                    if (Objects.isNull(con.getErrorStream())) {
                        HttpResponse httpResponse = new HttpResponse(responseCode, String.valueOf(responseCode) + " " + con.getResponseMessage());
                        return httpResponse;
                    }
                    in = new BufferedReader(new InputStreamReader(con.getErrorStream(), StandardCharsets.UTF_8));
                } else {
                    if (Objects.isNull(con.getInputStream())) {
                        HttpResponse httpResponse = new HttpResponse(responseCode, "");
                        return httpResponse;
                    }
                    in = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));
                }
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                return new HttpResponse(responseCode, response.toString());
            }
        }
        catch (IOException e) {
            BrokerClientException exception = new BrokerClientException();
            exception.addMessage("error calling broker https service");
            exception.addMessage(e.getMessage());
            throw exception;
        }
    }

    private static class X509UntrustManagerImpl
    implements X509TrustManager {
        private X509UntrustManagerImpl() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

