/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.list;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.Gson;
import io.ballerina.messaging.broker.client.cmd.impl.list.ListCmd;
import io.ballerina.messaging.broker.client.http.HttpClient;
import io.ballerina.messaging.broker.client.http.HttpRequest;
import io.ballerina.messaging.broker.client.http.HttpResponse;
import io.ballerina.messaging.broker.client.output.ResponseFormatter;
import io.ballerina.messaging.broker.client.output.TableFormatter;
import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.resources.Exchange;
import io.ballerina.messaging.broker.client.utils.Utils;

@Parameters(commandDescription="List exchange(s) in the Broker")
public class ListExchangeCmd
extends ListCmd {
    @Parameter(names={"--all", "-a"}, description="return info on all exchanges of the broker")
    private boolean all;
    @Parameter(description="name of the exchange which info needs to be retrieved")
    private String exchangeName = "";

    public ListExchangeCmd(String rootCommand) {
        super(rootCommand);
    }

    @Override
    public void execute() {
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Configuration configuration = Utils.readConfigurationFile();
        HttpClient httpClient = new HttpClient(configuration);
        String urlSuffix = "exchanges/";
        if (this.all) {
            this.exchangeName = "";
        }
        HttpResponse response = httpClient.sendHttpRequest(new HttpRequest(urlSuffix + this.exchangeName), "GET");
        TableFormatter responseFormatter = new TableFormatter();
        if (response.getStatusCode() == 200) {
            Gson gson = new Gson();
            Exchange[] exchanges = this.exchangeName.isEmpty() ? (Exchange[])gson.fromJson(response.getPayload(), Exchange[].class) : new Exchange[]{(Exchange)gson.fromJson(response.getPayload(), Exchange.class)};
            responseFormatter.printExchanges(exchanges);
        } else {
            ResponseFormatter.handleErrorResponse(this.buildResponseMessage(response, "Error while invoking Brokers admin services"));
        }
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " list exchange [exchange-name]? [flag]*\n");
    }
}

