/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd.impl.create;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.ballerina.messaging.broker.client.cmd.impl.create.CreateCmd;
import io.ballerina.messaging.broker.client.http.HttpClient;
import io.ballerina.messaging.broker.client.http.HttpRequest;
import io.ballerina.messaging.broker.client.http.HttpResponse;
import io.ballerina.messaging.broker.client.output.ResponseFormatter;
import io.ballerina.messaging.broker.client.resources.Configuration;
import io.ballerina.messaging.broker.client.resources.Exchange;
import io.ballerina.messaging.broker.client.resources.Message;
import io.ballerina.messaging.broker.client.utils.Utils;

@Parameters(commandDescription="Create an exchange in the Broker with parameters")
public class CreateExchangeCmd
extends CreateCmd {
    @Parameter(description="name of the exchange")
    private String exchangeName;
    @Parameter(names={"--type", "-t"}, description="type of the exchange")
    private String type = "direct";
    @Parameter(names={"--durable", "-d"}, description="durability of the exchange")
    private boolean durable = false;

    public CreateExchangeCmd(String rootCommand) {
        super(rootCommand);
    }

    @Override
    public void execute() {
        Exchange exchange;
        String urlSuffix;
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Configuration configuration = Utils.readConfigurationFile();
        HttpClient httpClient = new HttpClient(configuration);
        HttpResponse response = httpClient.sendHttpRequest(new HttpRequest(urlSuffix = "exchanges/", (exchange = new Exchange(this.exchangeName, this.type, this.durable)).getAsJsonString()), "POST");
        if (response.getStatusCode() == 201) {
            Message message = this.buildResponseMessage(response, "Exchange created successfully");
            ResponseFormatter.printMessage(message);
        } else {
            ResponseFormatter.handleErrorResponse(this.buildResponseMessage(response, "Error while invoking Brokers admin services"));
        }
    }

    @Override
    public void appendUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  " + this.rootCommand + " create exchange [exchange-name] [flag]*\n");
    }
}

