/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.ballerina.messaging.broker.client.cmd.MBClientCmd;
import java.io.PrintStream;
import java.util.Map;

public abstract class AbstractCmd
implements MBClientCmd {
    protected static final PrintStream ERR_STREAM = System.err;
    protected String rootCommand;
    protected JCommander selfJCommander;
    @Parameter(names={"--help", "-h"}, help=true, hidden=true)
    protected boolean help;
    @Parameter(names={"--verbose", "-v"}, hidden=true)
    protected boolean verbose;

    protected AbstractCmd(String rootCommand) {
        this.rootCommand = rootCommand;
    }

    @Override
    public void setSelfJCommander(JCommander selfJCommander) {
        this.selfJCommander = selfJCommander;
    }

    protected void processHelpLogs() {
        StringBuilder sb = new StringBuilder();
        AbstractCmd.appendCommandDescription(this.selfJCommander, sb);
        this.appendUsage(sb);
        sb.append("\n");
        AbstractCmd.appendChildCommandsInfo(this.selfJCommander, sb);
        AbstractCmd.appendFlagsInfo(this.selfJCommander, sb);
        AbstractCmd.appendGlobalFlagsInfo(sb);
        ERR_STREAM.println(sb.toString());
    }

    static void appendCommandDescription(JCommander jCommander, StringBuilder sb) {
        MBClientCmd selfCommand = (MBClientCmd)jCommander.getObjects().get(0);
        if (selfCommand.getClass().getAnnotations().length == 0) {
            return;
        }
        Parameters parameters = (Parameters)selfCommand.getClass().getAnnotations()[0];
        String commandDescription = parameters.commandDescription();
        sb.append(commandDescription);
        sb.append("\n\n");
    }

    static void appendChildCommandsInfo(JCommander jCommander, StringBuilder sb) {
        Map commandMap = jCommander.getCommands();
        if (commandMap.isEmpty()) {
            return;
        }
        sb.append("Commands:\n");
        jCommander.getCommands().keySet().forEach(key -> {
            sb.append("  ");
            sb.append((String)key);
            sb.append("\t");
            sb.append(jCommander.getCommandDescription(key));
            sb.append("\n");
        });
        sb.append("\n");
    }

    static void appendFlagsInfo(JCommander jCommander, StringBuilder sb) {
        boolean isFlagsExists = jCommander.getParameters().stream().anyMatch(param -> !param.getParameter().hidden());
        if (!isFlagsExists) {
            return;
        }
        sb.append("Flags:\n");
        jCommander.getParameters().stream().filter(param -> !param.getParameter().hidden()).forEach(param -> {
            sb.append("  ");
            sb.append(param.getNames());
            sb.append("\t");
            sb.append(param.getDescription());
            sb.append(" (Default: ");
            sb.append(param.getDefault());
            sb.append(")\n");
        });
        sb.append("\n");
    }

    static void appendGlobalFlagsInfo(StringBuilder sb) {
        sb.append("Global Flags:\n");
        sb.append("  --verbose, -v\t");
        sb.append("enable verbose mode (Default: false)\n");
        sb.append("  --help, -h\t");
        sb.append("ask for help\n");
    }
}

