/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.client;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.ParameterException;
import io.ballerina.messaging.broker.client.cmd.CommandFactory;
import io.ballerina.messaging.broker.client.cmd.MBClientCmd;
import io.ballerina.messaging.broker.client.cmd.impl.RootCmd;
import io.ballerina.messaging.broker.client.utils.BrokerClientException;
import io.ballerina.messaging.broker.client.utils.Utils;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Main {
    private static PrintStream outStream = System.err;

    public static void main(String ... argv) {
        if (argv.length == 0) {
            return;
        }
        String rootCommand = argv[0];
        if (argv.length == 1) {
            argv[0] = "--help";
        }
        if (argv.length > 1) {
            argv = Arrays.copyOfRange(argv, 1, argv.length);
        }
        JCommander parserTreeRoot = Main.buildCommanderTree(rootCommand);
        try {
            Main.parseInput(parserTreeRoot, rootCommand, argv);
            Main.findLeafCommand(parserTreeRoot).execute();
        }
        catch (BrokerClientException e) {
            Main.printBrokerClientException(e, outStream);
        }
    }

    private static JCommander buildCommanderTree(String rootCommand) {
        CommandFactory commandFactory = new CommandFactory(rootCommand);
        RootCmd rootCmd = commandFactory.createRootCommand();
        JCommander jCommanderRoot = new JCommander((Object)rootCmd);
        rootCmd.setSelfJCommander(jCommanderRoot);
        Main.addChildCommand(jCommanderRoot, "init", commandFactory.createInitCommand());
        JCommander jCommanderList = Main.addChildCommand(jCommanderRoot, "list", commandFactory.createListCommand());
        JCommander jCommanderCreate = Main.addChildCommand(jCommanderRoot, "create", commandFactory.createCreateCommand());
        JCommander jCommanderDelete = Main.addChildCommand(jCommanderRoot, "delete", commandFactory.createDeleteCommand());
        Main.addChildCommand(jCommanderList, "exchange", commandFactory.createListExchangeCommand());
        Main.addChildCommand(jCommanderCreate, "exchange", commandFactory.createCreateExchangeCommand());
        Main.addChildCommand(jCommanderDelete, "exchange", commandFactory.createDeleteExchangeCommand());
        return jCommanderRoot;
    }

    private static void parseInput(JCommander jCommanderRoot, String rootCommand, String ... argv) {
        try {
            jCommanderRoot.parse(argv);
        }
        catch (MissingCommandException e) {
            String errorMsg = "unknown command '" + e.getUnknownCommand() + "'";
            throw Utils.createUsageException(errorMsg, rootCommand);
        }
        catch (ParameterException e) {
            throw Utils.createUsageException(e.getMessage(), rootCommand);
        }
    }

    private static MBClientCmd findLeafCommand(JCommander jCommander) {
        String commandText = jCommander.getParsedCommand();
        if (Objects.isNull(commandText)) {
            return (MBClientCmd)jCommander.getObjects().get(0);
        }
        return Main.findLeafCommand((JCommander)jCommander.getCommands().get(commandText));
    }

    private static JCommander addChildCommand(JCommander parentCommander, String commandName, MBClientCmd commandObject) {
        parentCommander.addCommand(commandName, (Object)commandObject);
        JCommander childCommander = (JCommander)parentCommander.getCommands().get(commandName);
        commandObject.setSelfJCommander(childCommander);
        return childCommander;
    }

    private static void printBrokerClientException(BrokerClientException e, PrintStream outStream) {
        List<String> errorMessages = e.getMessages();
        errorMessages.forEach(outStream::println);
    }
}

