/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.jsonb.core.ViewDsl;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class ViewDslParser {
    private final Context top;
    private StringBuilder sb = new StringBuilder();
    private Context current = this.top = new Context(null);

    ViewDslParser() {
    }

    ViewDsl parse(String dsl) {
        char[] chars;
        dsl = this.initialTrim(dsl);
        block5: for (char ch : chars = dsl.toCharArray()) {
            switch (ch) {
                case ',': {
                    this.tokenSplit();
                    continue block5;
                }
                case '(': {
                    this.tokenBegin();
                    continue block5;
                }
                case ')': {
                    this.tokenEnd();
                }
                default: {
                    this.sb.append(ch);
                }
            }
        }
        this.addToken();
        return new ViewDsl(this.top.build());
    }

    private String initialTrim(String dsl) {
        if ((dsl = dsl.trim()).startsWith("(") && dsl.endsWith(")")) {
            dsl = dsl.substring(1, dsl.length() - 1).trim();
        }
        return dsl;
    }

    private void tokenEnd() {
        this.addToken();
        this.current = this.current.pop();
    }

    private void tokenBegin() {
        this.addToken();
        this.current = this.current.push(this.current.last());
    }

    private void tokenSplit() {
        this.addToken();
    }

    private void addToken() {
        if (this.sb.length() > 0) {
            this.current.add(this.sb.toString().trim());
            this.sb = new StringBuilder();
        }
    }

    static class Context {
        private final Context parent;
        private final Set<String> tokens = new LinkedHashSet<String>();
        private final Map<String, Context> nested = new LinkedHashMap<String, Context>();
        private String last;

        Context(Context parent) {
            this.parent = parent;
        }

        void add(String token) {
            this.last = token;
            this.tokens.add(token);
        }

        String last() {
            return this.last;
        }

        Context push(String last) {
            Context child = new Context(this);
            this.nested.put(last, child);
            return child;
        }

        Context pop() {
            return this.parent;
        }

        ViewDsl.Entry build() {
            LinkedHashMap<String, ViewDsl.Entry> children = new LinkedHashMap<String, ViewDsl.Entry>();
            for (Map.Entry<String, Context> entry : this.nested.entrySet()) {
                children.put(entry.getKey(), entry.getValue().build());
            }
            return new ViewDsl.Entry(this.tokens, children);
        }
    }
}

