/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.jsonb.core.DJsonClosable;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class StreamAdapter<T>
implements DJsonClosable<Stream<T>>,
JsonAdapter<Stream<T>> {
    private final JsonAdapter<T> elementAdapter;
    private final boolean lineDelimited;

    StreamAdapter(JsonAdapter<T> elementAdapter, boolean lineDelimited) {
        this.elementAdapter = elementAdapter;
        this.lineDelimited = lineDelimited;
    }

    public void toJson(JsonWriter writer, Stream<T> stream) {
        try (Stream<Object> stream2 = stream;){
            if (this.lineDelimited) {
                writer.pretty(false);
                stream.forEach(bean -> {
                    this.elementAdapter.toJson(writer, bean);
                    writer.writeNewLine();
                });
                writer.writeNewLine();
            } else {
                writer.beginArray();
                stream.forEach(bean -> this.elementAdapter.toJson(writer, bean));
                writer.endArray();
            }
        }
    }

    public Stream<T> fromJson(JsonReader reader) {
        Iter<T> iterator = new Iter<T>(this.elementAdapter, reader, false);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    @Override
    public Stream<T> fromJsonWithClose(JsonReader reader) {
        Iter<T> iterator = new Iter<T>(this.elementAdapter, reader, true);
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).onClose(() -> ((JsonReader)reader).close());
    }

    static class Iter<T>
    implements Iterator<T> {
        private final JsonAdapter<T> elementAdapter;
        private final JsonReader reader;
        private final boolean closeReader;

        Iter(JsonAdapter<T> elementAdapter, JsonReader reader, boolean closeReader) {
            this.elementAdapter = elementAdapter;
            this.reader = reader;
            this.closeReader = closeReader;
            reader.beginStream();
        }

        @Override
        public boolean hasNext() {
            boolean result = this.reader.hasNextStreamElement();
            if (!result) {
                this.endStream();
            }
            return result;
        }

        @Override
        public T next() {
            return (T)this.elementAdapter.fromJson(this.reader);
        }

        private void endStream() {
            this.reader.endStream();
            if (this.closeReader) {
                this.reader.close();
            }
        }
    }
}

