/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.jsonb.spi.GeneratedComponent;
import io.avaje.jsonb.spi.JsonStreamFactory;
import io.avaje.jsonb.spi.JsonbComponent;
import io.avaje.jsonb.spi.JsonbExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

final class ExtensionLoader {
    private static final List<GeneratedComponent> generatedComponents = new ArrayList<GeneratedComponent>();
    private static final List<JsonbComponent> userComponents = new ArrayList<JsonbComponent>();
    private static Optional<JsonStreamFactory> adapterFactory = Optional.empty();

    ExtensionLoader() {
    }

    static void init(ClassLoader classLoader) {
        for (JsonbExtension spi : ServiceLoader.load(JsonbExtension.class, classLoader)) {
            if (spi instanceof GeneratedComponent) {
                generatedComponents.add((GeneratedComponent)spi);
                continue;
            }
            if (spi instanceof JsonbComponent) {
                userComponents.add((JsonbComponent)spi);
                continue;
            }
            if (!(spi instanceof JsonStreamFactory)) continue;
            adapterFactory = Optional.of((JsonStreamFactory)spi);
        }
    }

    static List<GeneratedComponent> generatedComponents() {
        return generatedComponents;
    }

    static List<JsonbComponent> userComponents() {
        return userComponents;
    }

    static Optional<JsonStreamFactory> adapterFactory() {
        return adapterFactory;
    }
}

