/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.PropertyNames;
import io.avaje.json.stream.BufferRecycleStrategy;
import io.avaje.json.stream.BufferedJsonWriter;
import io.avaje.json.stream.BytesJsonWriter;
import io.avaje.json.stream.JsonOutput;
import io.avaje.json.stream.JsonStream;
import io.avaje.json.view.ViewBuilder;
import io.avaje.jsonb.AdapterFactory;
import io.avaje.jsonb.JsonType;
import io.avaje.jsonb.JsonView;
import io.avaje.jsonb.Jsonb;
import io.avaje.jsonb.core.CoreAdapterBuilder;
import io.avaje.jsonb.core.CoreViewBuilder;
import io.avaje.jsonb.core.DJsonType;
import io.avaje.jsonb.core.ExtensionLoader;
import io.avaje.jsonb.core.ObjectJsonReader;
import io.avaje.jsonb.core.RawAdapter;
import io.avaje.jsonb.core.Util;
import io.avaje.jsonb.core.ViewDsl;
import io.avaje.jsonb.spi.GeneratedComponent;
import io.avaje.jsonb.spi.JsonStreamFactory;
import io.avaje.jsonb.spi.JsonbComponent;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

final class DJsonb
implements Jsonb {
    private final CoreAdapterBuilder builder;
    private final JsonStream io;
    private final Map<Type, DJsonType<?>> typeCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<ViewKey, JsonView<?>> viewCache = new ConcurrentHashMap();
    private final JsonType<Object> anyType;

    DJsonb(JsonStream adapter, List<AdapterFactory> factories, boolean serializeNulls, boolean serializeEmpty, boolean failOnUnknown, boolean failOnNullPrimitives, boolean mathAsString, boolean calendarAsString, BufferRecycleStrategy strategy) {
        Optional<JsonStreamFactory> adapterFactoryOptional;
        this.builder = new CoreAdapterBuilder(this, factories, mathAsString, calendarAsString);
        this.io = adapter != null ? adapter : ((adapterFactoryOptional = ExtensionLoader.adapterFactory()).isPresent() ? adapterFactoryOptional.get().create(serializeNulls, serializeEmpty, failOnUnknown) : JsonStream.builder().serializeNulls(serializeNulls).serializeEmpty(serializeEmpty).failOnUnknown(failOnUnknown).failOnNullPrimitives(failOnNullPrimitives).bufferRecycling(strategy).build());
        this.anyType = this.type(Object.class);
    }

    @Override
    public String toJson(Object any) {
        return this.anyType.toJson(any);
    }

    @Override
    public String toJsonPretty(Object any) {
        return this.anyType.toJsonPretty(any);
    }

    @Override
    public byte[] toJsonBytes(Object any) {
        return this.anyType.toJsonBytes(any);
    }

    @Override
    public void toJson(Object any, Writer writer) {
        this.anyType.toJson(any, writer);
    }

    @Override
    public void toJson(Object any, OutputStream outputStream) {
        this.anyType.toJson(any, outputStream);
    }

    @Override
    public void toJson(Object any, JsonWriter jsonWriter) {
        this.anyType.toJson(any, jsonWriter);
    }

    @Override
    public void toJson(Object any, JsonOutput jsonOutput) {
        this.anyType.toJson(any, jsonOutput);
    }

    @Override
    public PropertyNames properties(String ... names) {
        return this.io.properties(names);
    }

    BufferedJsonWriter bufferedWriter() {
        return this.io.bufferedWriter();
    }

    BytesJsonWriter bufferedWriterAsBytes() {
        return this.io.bufferedWriterAsBytes();
    }

    @Override
    public JsonWriter writer(Writer writer) {
        return this.io.writer(writer);
    }

    @Override
    public JsonWriter writer(OutputStream outputStream) {
        return this.io.writer(outputStream);
    }

    @Override
    public JsonWriter writer(JsonOutput output) {
        return this.io.writer(output);
    }

    @Override
    public JsonReader reader(Reader reader) {
        return this.io.reader(reader);
    }

    @Override
    public JsonReader reader(InputStream inputStream) {
        return this.io.reader(inputStream);
    }

    @Override
    public JsonReader reader(String json) {
        return this.io.reader(json);
    }

    @Override
    public JsonReader reader(byte[] json) {
        return this.io.reader(json);
    }

    @Override
    public <T> JsonType<T> type(Class<T> cls) {
        return this.typeWithCache(cls);
    }

    @Override
    public <T> JsonType<T> type(Type type) {
        return this.typeWithCache(type);
    }

    @Override
    public <T> JsonType<T> typeOf(Object first) {
        Objects.requireNonNull(first);
        return this.type((Type)first.getClass());
    }

    private <T> JsonType<T> typeWithCache(Type type) {
        return this.typeCache.computeIfAbsent(type, _type -> new DJsonType(this, (Type)_type, this.adapter((Type)_type)));
    }

    @Override
    public <T> JsonAdapter<T> customAdapter(Class<? extends JsonAdapter<?>> cls) {
        return this.adapter(cls);
    }

    @Override
    public <T> JsonAdapter<T> adapter(Class<T> cls) {
        Type cacheKey = Util.canonicalizeClass(Objects.requireNonNull(cls));
        JsonAdapter result = this.builder.get(cacheKey);
        if (result != null) {
            return result;
        }
        return this.builder.build(cacheKey);
    }

    @Override
    public <T> JsonAdapter<T> adapter(Type type) {
        Type cacheKey = type = Util.removeSubtypeWildcard(Util.canonicalize(Objects.requireNonNull(type)));
        JsonAdapter result = this.builder.get(cacheKey);
        if (result != null) {
            return result;
        }
        return this.builder.build(type, cacheKey);
    }

    @Override
    public JsonAdapter<String> rawAdapter() {
        return RawAdapter.STR;
    }

    @Override
    public boolean hasAdapter(Class<?> cls) {
        Type cacheKey = Util.canonicalizeClass(Objects.requireNonNull(cls));
        return this.builder.hasAdapter(cacheKey);
    }

    @Override
    public boolean hasAdapter(Type type) {
        type = Util.removeSubtypeWildcard(Util.canonicalize(Objects.requireNonNull(type)));
        return this.builder.hasAdapter(type);
    }

    JsonReader objectReader(Object value) {
        return new ObjectJsonReader(value);
    }

    <T> JsonView<T> buildView(String dsl, JsonAdapter<T> adapter, Type type) {
        ViewKey key = new ViewKey(dsl, type);
        return this.viewCache.computeIfAbsent(key, o -> {
            try {
                CoreViewBuilder viewBuilder = new CoreViewBuilder(ViewDsl.parse(dsl));
                adapter.viewBuild().build((ViewBuilder)viewBuilder);
                return viewBuilder.build(this);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    static final class ViewKey {
        private final String dsl;
        private final Type type;

        ViewKey(String dsl, Type type) {
            this.dsl = dsl;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ViewKey viewKey = (ViewKey)o;
            return this.dsl.equals(viewKey.dsl) && this.type.equals(viewKey.type);
        }

        public int hashCode() {
            return Objects.hash(this.dsl, this.type);
        }
    }

    static final class DBuilder
    implements Jsonb.Builder {
        static final Jsonb DEFAULT = Jsonb.builder().build();
        private final List<AdapterFactory> factories = new ArrayList<AdapterFactory>();
        private boolean failOnUnknown;
        private boolean failOnNullPrimitives;
        private boolean mathTypesAsString;
        private boolean calendarAsString;
        private boolean serializeNulls;
        private boolean serializeEmpty = true;
        private JsonStream adapter;
        private BufferRecycleStrategy strategy = BufferRecycleStrategy.HYBRID_POOL;
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

        DBuilder() {
        }

        @Override
        public Jsonb.Builder serializeNulls(boolean serializeNulls) {
            this.serializeNulls = serializeNulls;
            return this;
        }

        @Override
        public Jsonb.Builder serializeEmpty(boolean serializeEmpty) {
            this.serializeEmpty = serializeEmpty;
            return this;
        }

        @Override
        public Jsonb.Builder failOnUnknown(boolean failOnUnknown) {
            this.failOnUnknown = failOnUnknown;
            return this;
        }

        @Override
        public Jsonb.Builder failOnNullPrimitives(boolean failOnNullPrimitives) {
            this.failOnNullPrimitives = failOnNullPrimitives;
            return this;
        }

        @Override
        public Jsonb.Builder mathTypesAsString(boolean mathTypesAsString) {
            this.mathTypesAsString = mathTypesAsString;
            return this;
        }

        @Override
        public Jsonb.Builder calendarAsString(boolean calendarAsString) {
            this.calendarAsString = calendarAsString;
            return this;
        }

        @Override
        public Jsonb.Builder bufferRecycling(BufferRecycleStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public Jsonb.Builder adapter(JsonStream streamAdapter) {
            this.adapter = streamAdapter;
            return this;
        }

        @Override
        public Jsonb.Builder add(Type type, Jsonb.AdapterBuilder builder) {
            return this.add(DBuilder.newAdapterFactory(type, builder));
        }

        @Override
        public <T> Jsonb.Builder add(Type type, JsonAdapter<T> jsonAdapter) {
            return this.add(DBuilder.newAdapterFactory(type, jsonAdapter));
        }

        @Override
        public <T> Jsonb.Builder add(Type type, Supplier<JsonAdapter<T>> jsonAdapter) {
            return this.add(DBuilder.newAdapterFactory(type, jsonAdapter));
        }

        @Override
        public Jsonb.Builder add(JsonbComponent component) {
            component.register(this);
            return this;
        }

        @Override
        public Jsonb.Builder add(AdapterFactory factory) {
            this.factories.add(factory);
            return this;
        }

        @Override
        public Jsonb.Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        private void registerComponents() {
            ExtensionLoader.init(this.classLoader);
            for (JsonbComponent jsonbComponent : ExtensionLoader.userComponents()) {
                jsonbComponent.register(this);
            }
            for (GeneratedComponent generatedComponent : ExtensionLoader.generatedComponents()) {
                generatedComponent.register(this);
            }
        }

        @Override
        public Jsonb build() {
            if (!this.hasCustomizations()) {
                return DEFAULT;
            }
            this.registerComponents();
            return new DJsonb(this.adapter, this.factories, this.serializeNulls, this.serializeEmpty, this.failOnUnknown, this.failOnNullPrimitives, this.mathTypesAsString, this.calendarAsString, this.strategy);
        }

        private boolean hasCustomizations() {
            return DEFAULT == null || this.adapter != null || !this.factories.isEmpty() || this.failOnUnknown || this.failOnNullPrimitives || this.mathTypesAsString || this.calendarAsString || this.serializeNulls || !this.serializeEmpty || BufferRecycleStrategy.HYBRID_POOL != this.strategy;
        }

        static <T> AdapterFactory newAdapterFactory(Type type, JsonAdapter<T> jsonAdapter) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(jsonAdapter);
            return (targetType, jsonb) -> DBuilder.simpleMatch(type, targetType) ? jsonAdapter : null;
        }

        static <T> AdapterFactory newAdapterFactory(Type type, Supplier<JsonAdapter<T>> jsonAdapter) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(jsonAdapter);
            return (targetType, jsonb) -> DBuilder.simpleMatch(type, targetType) ? ((JsonAdapter)jsonAdapter.get()).nullSafe() : null;
        }

        static AdapterFactory newAdapterFactory(Type type, Jsonb.AdapterBuilder builder) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(builder);
            return (targetType, jsonb) -> DBuilder.simpleMatch(type, targetType) ? builder.build(jsonb).nullSafe() : null;
        }

        private static boolean simpleMatch(Type type, Type targetType) {
            return Util.typesMatch(type, targetType);
        }
    }
}

