/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.ssl.core;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import io.avaje.jex.ssl.SslConfigException;
import io.avaje.jex.ssl.core.DSslConfig;
import io.avaje.jex.ssl.core.DTrustConfig;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class SSLConfigurator
extends HttpsConfigurator {
    private static final String SSL_PROTOCOL = "TLSv1.3";
    private static final String KEY_MANAGER_ALGORITHM = "SunX509";
    private static final String TRUST_MANAGER_ALGORITHM = "PKIX";
    private final boolean clientAuth;
    private final KeyStore keyStore;
    private final String password;

    SSLConfigurator(SSLContext context, DSslConfig sslConfig, boolean clientAuth) {
        super(context);
        this.keyStore = sslConfig.keyStore();
        this.password = sslConfig.identityPassword();
        this.clientAuth = clientAuth;
    }

    @Override
    public void configure(HttpsParameters params) {
        SSLParameters sslParams = this.getSSLContext().getDefaultSSLParameters();
        sslParams.setNeedClientAuth(this.clientAuth);
        params.setSSLParameters(sslParams);
    }

    static SSLConfigurator create(DSslConfig sslConfig) throws SslConfigException {
        try {
            SSLContext sslContext = SSLConfigurator.createContext(sslConfig);
            KeyManager[] keyManagers = SSLConfigurator.createKeyManagers(sslConfig);
            TrustManager[] trustManagers = SSLConfigurator.createTrustManagers(sslConfig);
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            return new SSLConfigurator(sslContext, sslConfig, trustManagers != null);
        }
        catch (Exception e) {
            throw new SslConfigException("Failed to build SSLContext", e);
        }
    }

    private static SSLContext createContext(DSslConfig sslConfig) throws NoSuchAlgorithmException {
        if (sslConfig.securityProvider() != null) {
            return SSLContext.getInstance(SSL_PROTOCOL, sslConfig.securityProvider());
        }
        return SSLContext.getInstance(SSL_PROTOCOL);
    }

    private static KeyManager[] createKeyManagers(DSslConfig sslConfig) throws SslConfigException {
        try {
            if (sslConfig.loadedIdentity()) {
                return SSLConfigurator.createKeyManagersFromKeyStore(sslConfig);
            }
            throw new IllegalStateException("No SSL Identity provided");
        }
        catch (Exception e) {
            throw new SslConfigException("Failed to create key managers", e);
        }
    }

    private static KeyManager[] createKeyManagersFromKeyStore(DSslConfig sslConfig) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = SSLConfigurator.createKeyManagerFactory(sslConfig);
        keyManagerFactory.init(sslConfig.keyStore(), sslConfig.identityPassword() != null ? sslConfig.identityPassword().toCharArray() : null);
        return keyManagerFactory.getKeyManagers();
    }

    private static KeyManagerFactory createKeyManagerFactory(DSslConfig sslConfig) throws NoSuchAlgorithmException {
        if (sslConfig.securityProvider() != null) {
            return KeyManagerFactory.getInstance(KEY_MANAGER_ALGORITHM, sslConfig.securityProvider());
        }
        return KeyManagerFactory.getInstance(KEY_MANAGER_ALGORITHM);
    }

    private static TrustManager[] createTrustManagers(DSslConfig sslConfig) throws SslConfigException {
        DTrustConfig trustConfig = sslConfig.trustConfig();
        if (trustConfig == null) {
            return null;
        }
        try {
            List<KeyStore> trustStores = trustConfig.keyStores();
            List<Certificate> certificates = trustConfig.certificates();
            if (trustStores.isEmpty() && certificates.isEmpty()) {
                return null;
            }
            KeyStore trustStore = SSLConfigurator.createCombinedTrustStore(trustStores, certificates);
            TrustManagerFactory trustManagerFactory = SSLConfigurator.createTrustManagerFactory(sslConfig);
            trustManagerFactory.init(trustStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception e) {
            throw new SslConfigException("Failed to create trust managers", e);
        }
    }

    private static TrustManagerFactory createTrustManagerFactory(DSslConfig sslConfig) throws NoSuchAlgorithmException {
        if (sslConfig.securityProvider() != null) {
            return TrustManagerFactory.getInstance(TRUST_MANAGER_ALGORITHM, sslConfig.securityProvider());
        }
        return TrustManagerFactory.getInstance(TRUST_MANAGER_ALGORITHM);
    }

    private static KeyStore createCombinedTrustStore(List<KeyStore> trustStores, List<Certificate> certificates) throws Exception {
        KeyStore combinedTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        combinedTrustStore.load(null, null);
        int aliasCounter = 0;
        for (KeyStore trustStore : trustStores) {
            aliasCounter = SSLConfigurator.addCertificatesFromKeyStore(combinedTrustStore, trustStore, aliasCounter);
        }
        for (Certificate certificate : certificates) {
            combinedTrustStore.setCertificateEntry("cert-" + aliasCounter, certificate);
            ++aliasCounter;
        }
        return combinedTrustStore;
    }

    private static int addCertificatesFromKeyStore(KeyStore destinationStore, KeyStore sourceStore, int aliasCounter) throws KeyStoreException {
        ArrayList<String> aliases = Collections.list(sourceStore.aliases());
        for (String alias : aliases) {
            if (!sourceStore.isCertificateEntry(alias)) continue;
            Certificate cert = sourceStore.getCertificate(alias);
            destinationStore.setCertificateEntry("imported-" + aliasCounter, cert);
            ++aliasCounter;
        }
        return aliasCounter;
    }

    public KeyStore keyStore() {
        return this.keyStore;
    }

    public String password() {
        return this.password;
    }
}

