/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.ssl.core;

import io.avaje.jex.ssl.SslConfigException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class KeyStoreUtil {
    private static final Pattern CERT_PATTERN = Pattern.compile("-----BEGIN CERTIFICATE-----(.+?)-----END CERTIFICATE-----", 32);
    private static final Pattern PRIVATE_KEY_PATTERN = Pattern.compile("-----BEGIN (?:RSA )?PRIVATE KEY-----(.+?)-----END (?:RSA )?PRIVATE KEY-----", 32);

    KeyStoreUtil() {
    }

    static KeyStore loadKeyStore(InputStream inputStream, char[] password) {
        byte[] data;
        try {
            data = inputStream.readAllBytes();
        }
        catch (IOException e) {
            throw new SslConfigException("Unable to load KeyStore", e);
        }
        KeyStore keyStore = KeyStoreUtil.tryLoadKeyStore(data, "PKCS12", password);
        if (keyStore != null) {
            return keyStore;
        }
        keyStore = KeyStoreUtil.tryLoadKeyStore(data, "JKS", password);
        if (keyStore != null) {
            return keyStore;
        }
        keyStore = KeyStoreUtil.tryLoadKeyStore(data, KeyStore.getDefaultType(), password);
        if (keyStore != null) {
            return keyStore;
        }
        throw new SslConfigException("Unable to load KeyStore - format not recognized or invalid password");
    }

    private static KeyStore tryLoadKeyStore(byte[] data, String type, char[] password) {
        KeyStore keyStore;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        try {
            KeyStore keyStore2 = KeyStore.getInstance(type);
            keyStore2.load(bis, password);
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        bis.close();
        return keyStore;
    }

    static KeyStore loadIdentityFromPem(InputStream certificateInputStream, String privateKeyContent, char[] password) {
        try {
            List<Certificate> certificates = KeyStoreUtil.parseCertificates(certificateInputStream);
            PrivateKey privateKey = KeyStoreUtil.parsePrivateKey(privateKeyContent, password);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            Certificate[] certChain = certificates.toArray(new Certificate[0]);
            String alias = "identity";
            char[] keyPassword = password != null ? password : new char[]{};
            keyStore.setKeyEntry(alias, privateKey, keyPassword, certChain);
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SslConfigException("Failed to create KeyManager from PEM content", e);
        }
    }

    static List<Certificate> parsePemCertificates(String content) {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Matcher matcher = CERT_PATTERN.matcher(content);
            while (matcher.find()) {
                String base64Cert = matcher.group(1).replaceAll("\\s", "");
                byte[] certBytes = Base64.getDecoder().decode(base64Cert);
                try (ByteArrayInputStream bis = new ByteArrayInputStream(certBytes);){
                    Certificate cert = factory.generateCertificate(bis);
                    certs.add(cert);
                }
            }
        }
        catch (Exception e) {
            throw new SslConfigException("Failed to parse PEM certificate", e);
        }
        if (certs.isEmpty()) {
            throw new SslConfigException("No valid certificate found in PEM content");
        }
        return certs;
    }

    static PrivateKey parsePrivateKey(String privateKeyContent, char[] password) {
        try {
            String[] algorithms;
            Matcher matcher = PRIVATE_KEY_PATTERN.matcher(privateKeyContent);
            if (!matcher.find()) {
                throw new IllegalArgumentException("No valid private key found in PEM content");
            }
            String base64Key = matcher.group(1).replaceAll("\\s+", "");
            byte[] keyBytes = Base64.getDecoder().decode(base64Key);
            for (String algorithm : algorithms = new String[]{"RSA", "EC", "DSA"}) {
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
                    return keyFactory.generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                }
            }
            throw new SslConfigException("Unable to parse private key with any supported algorithm");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SslConfigException("Failed to parse private key", e);
        }
    }

    static List<Certificate> parseCertificates(InputStream inputStream) {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        byte[] data = null;
        try (InputStream inputStream2 = inputStream;){
            data = inputStream.readAllBytes();
        }
        catch (IOException e) {
            throw new SslConfigException("Unable to load KeyStore", e);
        }
        String content = new String(data, StandardCharsets.UTF_8);
        if (content.contains("-----BEGIN CERTIFICATE-----")) {
            certs.addAll(KeyStoreUtil.parsePemCertificates(content));
        } else {
            try (ByteArrayInputStream bis = new ByteArrayInputStream(data);){
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> parsedCerts = factory.generateCertificates(bis);
                certs.addAll(parsedCerts);
            }
            catch (IOException | CertificateException e) {
                throw new SslConfigException("Unable to load KeyStore", e);
            }
        }
        return certs;
    }

    static List<Certificate> parseCertificates(String cert) {
        return KeyStoreUtil.parseCertificates(new ByteArrayInputStream(cert.getBytes(StandardCharsets.UTF_8)));
    }
}

