/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.ssl.core;

import io.avaje.jex.ssl.SslConfigException;
import io.avaje.jex.ssl.TrustConfig;
import io.avaje.jex.ssl.core.KeyStoreUtil;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

final class DTrustConfig
implements TrustConfig {
    private final List<Certificate> certificates = new ArrayList<Certificate>();
    private final List<KeyStore> keyStores = new ArrayList<KeyStore>();
    private final Function<String, InputStream> loader;

    DTrustConfig(Function<String, InputStream> loader) {
        this.loader = loader;
    }

    @Override
    public TrustConfig certificateFromClasspath(String certificateFile) {
        return this.certificateFromInputStream(this.loader.apply(certificateFile));
    }

    @Override
    public TrustConfig certificateFromInputStream(InputStream certificateInputStream) {
        this.certificates.addAll(KeyStoreUtil.parseCertificates(certificateInputStream));
        return this;
    }

    @Override
    public TrustConfig certificateFromPath(String certificatePath) {
        try (InputStream is = Files.newInputStream(Paths.get(certificatePath, new String[0]), new OpenOption[0]);){
            this.certificates.addAll(KeyStoreUtil.parseCertificates(is));
        }
        catch (Exception e) {
            throw new SslConfigException("Failed to load certificates from path: " + certificatePath, e);
        }
        return this;
    }

    List<Certificate> certificates() {
        return this.certificates;
    }

    List<KeyStore> keyStores() {
        return this.keyStores;
    }

    @Override
    public TrustConfig certificateFromString(String cert) {
        this.certificates.addAll(KeyStoreUtil.parseCertificates(cert));
        return this;
    }

    @Override
    public TrustConfig trustStoreFromClasspath(String trustStoreFile, String trustStorePassword) {
        return this.trustStoreFromInputStream(this.loader.apply(trustStoreFile), trustStorePassword);
    }

    @Override
    public TrustConfig trustStoreFromInputStream(InputStream trustStoreInputStream, String trustStorePassword) {
        this.keyStores.add(KeyStoreUtil.loadKeyStore(trustStoreInputStream, trustStorePassword.toCharArray()));
        return this;
    }

    @Override
    public TrustConfig trustStoreFromPath(String trustStorePath, String trustStorePassword) {
        try (InputStream is = Files.newInputStream(Paths.get(trustStorePath, new String[0]), new OpenOption[0]);){
            this.keyStores.add(KeyStoreUtil.loadKeyStore(is, trustStorePassword.toCharArray()));
        }
        catch (Exception e) {
            throw new SslConfigException("Failed to load trust store from path: " + trustStorePath, e);
        }
        return this;
    }
}

